/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.log4j.pattern;

import com.flipkart.poseidon.log4j.message.IAccessLog;
import com.flipkart.poseidon.log4j.pattern.AccessLogPatternConverter;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;

@Plugin(name="RequestHeaderPatternConverter", category="Converter")
@ConverterKeys(value={"requestHeader"})
public class RequestHeaderPatternConverter
extends AccessLogPatternConverter {
    private String headerName;

    public RequestHeaderPatternConverter(String[] options) {
        if (options != null && options.length > 0 && options[0] != null) {
            this.headerName = options[0];
        }
    }

    public static RequestHeaderPatternConverter newInstance(String[] options) {
        return new RequestHeaderPatternConverter(options);
    }

    @Override
    protected void format(IAccessLog accessLog, StringBuilder stringBuilder) {
        if (this.headerName != null && !this.headerName.isEmpty()) {
            stringBuilder.append(accessLog.getRequestHeader(this.headerName));
        } else {
            stringBuilder.append(accessLog.getRequestHeaders());
        }
    }
}

