/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.handlers.http.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.phantom.task.impl.RequestCacheableHystrixTaskHandler;
import com.flipkart.phantom.task.spi.Decoder;
import com.flipkart.phantom.task.spi.TaskContext;
import com.flipkart.phantom.task.spi.TaskRequestWrapper;
import com.flipkart.phantom.task.spi.TaskResult;
import com.flipkart.poseidon.handlers.http.HttpResponseData;
import com.flipkart.poseidon.handlers.http.HttpResponseDecoder;
import com.flipkart.poseidon.handlers.http.impl.HttpConnectionPool;
import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.util.EntityUtils;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class SinglePoolHttpTaskHandler
extends RequestCacheableHystrixTaskHandler {
    private static final Logger logger = LogFactory.getLogger(SinglePoolHttpTaskHandler.class);
    protected static ObjectMapper objectMapper = new ObjectMapper();
    private final String invalid = "INVALID";
    private final int extraExecutionTime = 100;
    public final String commandPrefix = "HttpRequest";
    public String poolName = "INVALID";
    public String host = "localhost";
    public int port = 80;
    public int connectionTimeout = 1000;
    public int operationTimeout = 1000;
    public int queueSize = 0;
    private int timeToLiveInSecs = -1;
    public boolean isSecure = false;
    public String accept = "application/json";
    public String contentType = "application/json";
    public boolean requestCompressionEnabled = false;
    public boolean responseCompressionEnabled = false;
    private boolean requestCachingEnabled = false;
    public boolean handleRedirect = true;
    private static final String colon = ":";
    public boolean enableAsyncExecution = false;
    private HttpConnectionPool pool;

    public String getName() {
        return this.poolName + "Http";
    }

    public String[] getCommands() {
        return new String[]{this.poolName + "HttpRequest"};
    }

    public void init(TaskContext taskContext) throws Exception {
        if ("INVALID".equals(this.poolName)) {
            throw new Exception("Invalid pool name specified");
        }
        int maxConnections = this.getMaxConnectionsFromPoolParams(this.getCommandPoolSizeParams());
        if (maxConnections == 0) {
            maxConnections = this.getMaxConnectionsFromPoolParams(this.getConcurrentPoolSizeParams());
        }
        if (maxConnections == 0) {
            maxConnections = 10;
        }
        this.pool = new HttpConnectionPool(this.poolName, this.host, this.port, this.isSecure, this.connectionTimeout, this.operationTimeout + 100, maxConnections, this.queueSize, this.timeToLiveInSecs, this.handleRedirect);
        if (!this.accept.isEmpty()) {
            this.pool.setHeader("Accept", this.accept);
        }
        if (!this.contentType.isEmpty()) {
            this.pool.setHeader("Content-Type", this.contentType);
        }
        this.pool.setRequestGzipEnabled(this.isRequestCompressionEnabled());
        this.pool.setResponseGzipEnabled(this.isResponseCompressionEnabled());
        this.executorTimeouts.put(this.poolName + "HttpRequest", this.operationTimeout);
    }

    public <T, S> TaskResult<T> execute(TaskContext taskContext, String command, TaskRequestWrapper<S> taskRequestWrapper, Decoder<T> decoder) throws RuntimeException {
        logger.info("Thread executing execute - {}", (Object)Thread.currentThread().getName());
        Map params = taskRequestWrapper.getParams();
        byte[] data = (byte[])taskRequestWrapper.getData();
        Map<String, String> requestHeaders = this.getRequestHeaders(params);
        if (taskRequestWrapper.getHeaders().isPresent()) {
            ((List)taskRequestWrapper.getHeaders().get()).stream().forEach(entry -> {
                String cfr_ignored_0 = (String)requestHeaders.put((String)entry.getKey(), (String)entry.getValue());
            });
        }
        try {
            HttpRequestBase request = this.pool.createHttpRequest((String)params.get("uri"), data, requestHeaders, (String)params.get("method"));
            HttpResponse httpResponse = this.pool.execute(request);
            return new TaskResult(true, null, ((HttpResponseDecoder)decoder).decode(httpResponse));
        }
        catch (Exception e) {
            this.handleException(e, (String)params.get("uri"), (String)params.get("method"));
            return null;
        }
    }

    public <T, S> TaskResult<T> execute(TaskContext taskContext, String command, Map<String, Object> params, S data) {
        TaskResult result;
        Map<String, String> requestHeaders = this.getRequestHeaders(params);
        if (params.get("executeAsync") != null && Boolean.parseBoolean((String)params.get("executeAsync"))) {
            return this.processAsyncHttpRequest(taskContext, command, params, (byte[])data);
        }
        try {
            result = this.handleHttpResponse(this.makeRequest((String)params.get("method"), (String)params.get("uri"), (byte[])data, requestHeaders));
        }
        catch (Exception e) {
            result = this.handleException(e, (String)params.get("uri"), (String)params.get("method"));
        }
        return result;
    }

    public <S> String getCacheKey(Map<String, String> requestParams, S data) {
        if (!this.requestCachingEnabled || requestParams == null) {
            return null;
        }
        boolean hasURI = requestParams.containsKey("uri");
        boolean isGet = "GET".equalsIgnoreCase(requestParams.get("method"));
        boolean askedTobeCached = "true".equalsIgnoreCase(requestParams.get("X-Cache-Request"));
        if (!hasURI || !isGet && !askedTobeCached) {
            return null;
        }
        String cacheKey = requestParams.get("uri") + (data != null ? new String((byte[])data) : "");
        return Hashing.murmur3_32().hashString((CharSequence)cacheKey, Charsets.UTF_16LE).toString();
    }

    public <T, S> TaskResult<T> getFallBack(TaskContext taskContext, String command, Map<String, Object> params, S data) {
        throw new UnsupportedOperationException("No fallback available.");
    }

    public <T, S> TaskResult<T> getFallBack(TaskContext taskContext, String command, TaskRequestWrapper<S> taskRequestWrapper, Decoder<T> decoder) throws RuntimeException {
        throw new UnsupportedOperationException("No fallback available.");
    }

    public void shutdown(TaskContext taskContext) throws Exception {
    }

    protected Map<String, String> getRequestHeaders(Map<String, Object> params) {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        if (params != null) {
            Map customHeaders;
            if (params.containsKey("requestID")) {
                requestHeaders.put("X-Request-ID", (String)params.get("requestID"));
            }
            if (params.containsKey("headers") && (customHeaders = (Map)params.get("headers")) != null) {
                for (Map.Entry entry : customHeaders.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    requestHeaders.put((String)entry.getKey(), entry.getValue().toString());
                }
            }
        }
        return requestHeaders;
    }

    protected final HttpResponseData makeRequest(String method, String uri, byte[] data, Map<String, String> requestHeaders) throws Exception {
        HttpRequestBase request = this.pool.createHttpRequest(uri, data, requestHeaders, method);
        return this.getHttpResponseData(this.pool.execute(request));
    }

    protected TaskResult processAsyncHttpRequest(TaskContext taskContext, String command, Map<String, Object> params, byte[] data) {
        HttpResponse response = null;
        try {
            if (!this.enableAsyncExecution) {
                response = this.getDummyHttpResponse(503);
                return this.handleHttpResponse(this.getHttpResponseData(response));
            }
            params.remove("executeAsync");
            response = this.getDummyHttpResponse(200);
            taskContext.executeAsyncCommand(command, (Object)data, params);
            return this.handleHttpResponse(this.getHttpResponseData(response));
        }
        catch (Exception e) {
            this.handleException(e, (String)params.get("uri"), (String)params.get("method"));
            return new TaskResult(false, null, null);
        }
    }

    protected TaskResult handleException(Exception e, String uri, String method) {
        throw new RuntimeException(e.getMessage() + "(URI = " + uri + ", METHOD = " + method + ")", e);
    }

    protected TaskResult handleHttpResponse(HttpResponseData responseData) throws Exception {
        return new TaskResult(true, null, (Object)responseData.getResponseBody(), (responseData.getStatusCode() + colon).getBytes());
    }

    protected Map<String, String> getResponseHeaders(Header[] responseHeaders) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (responseHeaders != null) {
            for (Header header : responseHeaders) {
                headers.put(header.getName(), header.getValue());
            }
        }
        return headers;
    }

    private HttpResponseData getHttpResponseData(HttpResponse httpResponse) throws Exception {
        return new HttpResponseData(httpResponse.getStatusLine().getStatusCode(), this.getResponseBody(httpResponse), this.getResponseHeaders(httpResponse.getAllHeaders()));
    }

    private byte[] getResponseBody(HttpResponse response) throws Exception {
        if (response.getEntity() != null) {
            return EntityUtils.toByteArray((HttpEntity)response.getEntity());
        }
        return "".getBytes();
    }

    private HttpResponse getDummyHttpResponse(int statusCode) {
        BasicHttpResponse response = null;
        switch (statusCode) {
            case 200: {
                response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
                break;
            }
            case 500: {
                response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 500, "Internal Server Error");
                break;
            }
            case 503: {
                response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 503, "Service Unavailable");
                break;
            }
            default: {
                response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 400, "Bad Request");
            }
        }
        return response;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public void setSecure(boolean secure) {
        this.isSecure = secure;
    }

    public String getAccept() {
        return this.accept;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Boolean getEnableAsyncExecution() {
        return this.enableAsyncExecution;
    }

    public void setEnableAsyncExecution(Boolean enableAsyncExecution) {
        this.enableAsyncExecution = enableAsyncExecution;
    }

    public int getTimeToLiveInSecs() {
        return this.timeToLiveInSecs;
    }

    public void setTimeToLiveInSecs(int timeToLiveInSecs) {
        this.timeToLiveInSecs = timeToLiveInSecs;
    }

    public boolean isRequestCompressionEnabled() {
        return this.requestCompressionEnabled;
    }

    public void setRequestCompressionEnabled(boolean requestCompressionEnabled) {
        this.requestCompressionEnabled = requestCompressionEnabled;
    }

    public boolean isResponseCompressionEnabled() {
        return this.responseCompressionEnabled;
    }

    public void setResponseCompressionEnabled(boolean responseCompressionEnabled) {
        this.responseCompressionEnabled = responseCompressionEnabled;
    }

    public boolean isRequestCachingEnabled() {
        return this.requestCachingEnabled;
    }

    public void setRequestCachingEnabled(boolean requestCachingEnabled) {
        this.requestCachingEnabled = requestCachingEnabled;
    }

    private int getMaxConnectionsFromPoolParams(Map<String, Integer> poolSizeParams) {
        int maxConnections = 0;
        if (poolSizeParams != null && !poolSizeParams.isEmpty()) {
            for (Integer poolSize : poolSizeParams.values()) {
                maxConnections += poolSize.intValue();
            }
        }
        return maxConnections;
    }

    public boolean isHandleRedirect() {
        return this.handleRedirect;
    }

    public void setHandleRedirect(boolean handleRedirect) {
        this.handleRedirect = handleRedirect;
    }
}

