/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.legoset;

import com.flipkart.poseidon.core.RequestContext;
import com.flipkart.poseidon.serviceclients.ServiceContext;
import com.flipkart.poseidon.tracing.TraceHelper;
import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ServerSpan;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import flipkart.lego.api.entities.Filter;
import flipkart.lego.api.entities.Request;
import flipkart.lego.api.entities.Response;
import flipkart.lego.api.exceptions.BadRequestException;
import flipkart.lego.api.exceptions.InternalErrorException;
import flipkart.lego.api.exceptions.ProcessingException;
import flipkart.lego.api.helpers.Identifiable;
import java.util.List;
import java.util.Map;

public class ContextInducedFilter
implements Filter {
    private final Filter filter;
    private final Map<String, Object> parentContext;
    private final Map<String, Object> parentServiceContext;
    private final HystrixRequestContext parentThreadState;
    private final ServerSpan serverSpan;

    public ContextInducedFilter(Filter filter) {
        this.filter = filter;
        this.parentContext = RequestContext.getContextMap();
        this.parentServiceContext = ServiceContext.getContextMap();
        this.parentThreadState = HystrixRequestContext.getContextForCurrentThread();
        this.serverSpan = Brave.getServerSpanThreadBinder().getCurrentServerSpan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterRequest(Request request, Response response) throws InternalErrorException, BadRequestException, ProcessingException {
        HystrixRequestContext existingState = HystrixRequestContext.getContextForCurrentThread();
        boolean success = false;
        try {
            RequestContext.initialize(this.parentContext);
            ServiceContext.initialize(this.parentServiceContext);
            HystrixRequestContext.setContextOnCurrentThread((HystrixRequestContext)this.parentThreadState);
            if (this.serverSpan != null && this.serverSpan.getSpan() != null) {
                Brave.getServerSpanThreadBinder().setCurrentSpan(this.serverSpan);
            }
            TraceHelper.startTrace((Identifiable)this.filter);
            this.filter.filterRequest(request, response);
            success = true;
        }
        finally {
            TraceHelper.endTrace((Identifiable)this.filter, success);
            RequestContext.shutDown();
            ServiceContext.shutDown();
            HystrixRequestContext.setContextOnCurrentThread((HystrixRequestContext)existingState);
            Brave.getServerSpanThreadBinder().setCurrentSpan(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterResponse(Request request, Response response) throws InternalErrorException, BadRequestException, ProcessingException {
        HystrixRequestContext existingState = HystrixRequestContext.getContextForCurrentThread();
        boolean success = false;
        try {
            RequestContext.initialize(this.parentContext);
            ServiceContext.initialize(this.parentServiceContext);
            HystrixRequestContext.setContextOnCurrentThread((HystrixRequestContext)this.parentThreadState);
            if (this.serverSpan != null && this.serverSpan.getSpan() != null) {
                Brave.getServerSpanThreadBinder().setCurrentSpan(this.serverSpan);
            }
            TraceHelper.startTrace((Identifiable)this.filter);
            this.filter.filterResponse(request, response);
            success = true;
        }
        finally {
            TraceHelper.endTrace((Identifiable)this.filter, success);
            RequestContext.shutDown();
            ServiceContext.shutDown();
            HystrixRequestContext.setContextOnCurrentThread((HystrixRequestContext)existingState);
            Brave.getServerSpanThreadBinder().setCurrentSpan(null);
        }
    }

    public String getId() throws UnsupportedOperationException {
        return this.filter.getId();
    }

    public String getName() throws UnsupportedOperationException {
        return this.filter.getName();
    }

    public List<Integer> getVersion() throws UnsupportedOperationException {
        return this.filter.getVersion();
    }

    public boolean equals(Object o) {
        return o != null && o instanceof ContextInducedFilter && o.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return this.filter.hashCode();
    }

    public String getShortDescription() {
        return this.filter.getShortDescription();
    }

    public String getDescription() {
        return this.filter.getDescription();
    }
}

