/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.legoset;

import com.flipkart.poseidon.core.PoseidonRequest;
import com.flipkart.poseidon.helper.AnnotationHelper;
import com.flipkart.poseidon.helper.CallableNameHelper;
import com.flipkart.poseidon.legoset.ContextInducedDataSource;
import com.flipkart.poseidon.legoset.ContextInducedFilter;
import com.flipkart.poseidon.mappers.Mapper;
import com.flipkart.poseidon.model.annotations.Name;
import com.flipkart.poseidon.model.annotations.Version;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import flipkart.lego.api.entities.Buildable;
import flipkart.lego.api.entities.DataSource;
import flipkart.lego.api.entities.Filter;
import flipkart.lego.api.entities.LegoSet;
import flipkart.lego.api.entities.Request;
import flipkart.lego.api.entities.ServiceClient;
import flipkart.lego.api.exceptions.ElementNotFoundException;
import flipkart.lego.api.exceptions.LegoSetException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PoseidonLegoSet
implements LegoSet {
    private static final Logger logger = LoggerFactory.getLogger(PoseidonLegoSet.class);
    private static Map<String, Constructor<DataSource>> dataSources = new HashMap<String, Constructor<DataSource>>();
    private static Map<String, ServiceClient> serviceClients = new HashMap<String, ServiceClient>();
    private static Map<String, Filter> filters = new HashMap<String, Filter>();
    private static Map<String, Mapper> mappers = new HashMap<String, Mapper>();
    private Map<String, Buildable> buildableMap = new HashMap<String, Buildable>();
    private ExecutorService dataSourceExecutor;

    public PoseidonLegoSet() {
        try {
            ClassPath classpath = ClassPath.from((ClassLoader)ClassLoader.getSystemClassLoader());
            List<String> basePackagesToScan = this.getPackagesToScan();
            for (String basePackage : basePackagesToScan) {
                ImmutableSet classInfos = classpath.getTopLevelClassesRecursive(basePackage);
                for (ClassPath.ClassInfo classInfo : classInfos) {
                    this.bucketize(classInfo);
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to load lego-blocks into their containers", (Throwable)e);
        }
    }

    private void bucketize(ClassPath.ClassInfo aClass) {
        block9: {
            try {
                Class<?> klass = Class.forName(aClass.getName());
                if (this.isAbstract(klass)) break block9;
                if (DataSource.class.isAssignableFrom(klass)) {
                    Constructor<?> constructor = klass.getDeclaredConstructor(LegoSet.class, Request.class);
                    Optional<String> id = this.getBlockId(klass);
                    if (!id.isPresent()) {
                        id = Optional.of(((DataSource)constructor.newInstance(this, null)).getId());
                    }
                    dataSources.put(id.get(), constructor);
                    break block9;
                }
                if (ServiceClient.class.isAssignableFrom(klass)) {
                    Constructor<?> constructor = klass.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    ServiceClient serviceClient = (ServiceClient)constructor.newInstance(new Object[0]);
                    serviceClients.put(this.getBlockId(klass).orElseGet(() -> ((ServiceClient)serviceClient).getId()), serviceClient);
                    break block9;
                }
                if (Filter.class.isAssignableFrom(klass)) {
                    Filter filter;
                    try {
                        Constructor<?> constructor = klass.getDeclaredConstructor(LegoSet.class);
                        filter = (Filter)constructor.newInstance(this);
                    }
                    catch (NoSuchMethodException e) {
                        filter = (Filter)klass.newInstance();
                    }
                    filters.put(this.getBlockId(klass).orElseGet(() -> ((Filter)filter).getId()), filter);
                    break block9;
                }
                if (Mapper.class.isAssignableFrom(klass)) {
                    Mapper mapper = (Mapper)klass.newInstance();
                    mappers.put(this.getBlockId(klass).orElseGet(() -> ((Mapper)mapper).getId()), mapper);
                }
            }
            catch (Throwable t) {
                logger.error("Unable to instantiate " + aClass.getName(), t);
            }
        }
    }

    private Optional<String> getBlockId(Class klass) {
        Optional<String> optionalName = Optional.ofNullable(klass.getDeclaredAnnotation(Name.class)).map(Name::value);
        Optional<String> optionalVersion = Optional.ofNullable(klass.getDeclaredAnnotation(Version.class)).map(AnnotationHelper::constructVersion);
        String id = CallableNameHelper.versionedName((String)optionalName.orElse(klass.getSimpleName()), (String)optionalVersion.orElse(""));
        return optionalVersion.isPresent() ? Optional.of(id) : Optional.empty();
    }

    private boolean isAbstract(Class klass) {
        return Modifier.isAbstract(klass.getModifiers());
    }

    public DataSource getDataSource(String id, Request request) throws LegoSetException, ElementNotFoundException {
        if (!dataSources.containsKey(id)) {
            throw new ElementNotFoundException("Unable to find DataSource for provided id = " + id);
        }
        try {
            DataSource dataSource = dataSources.get(id).newInstance(this, request);
            return this.wrapDataSource(dataSource);
        }
        catch (Exception e) {
            throw new LegoSetException("Unable to instantiate DataSource for provided id = " + id, (Throwable)e);
        }
    }

    public DataSource wrapDataSource(DataSource dataSource) {
        return new ContextInducedDataSource(dataSource);
    }

    public ServiceClient getServiceClient(String id) throws ElementNotFoundException {
        if (!serviceClients.containsKey(id)) {
            throw new ElementNotFoundException("Unable to find ServiceClient for provided id = " + id);
        }
        return serviceClients.get(id);
    }

    public Filter getFilter(String id) throws ElementNotFoundException {
        if (!filters.containsKey(id)) {
            throw new ElementNotFoundException("Unable to find Filter for provided id = " + id);
        }
        return this.wrapFilter(filters.get(id));
    }

    public Filter wrapFilter(Filter filter) {
        return new ContextInducedFilter(filter);
    }

    public Mapper getMapper(String id) throws ElementNotFoundException {
        if (!mappers.containsKey(id)) {
            throw new ElementNotFoundException("Unable to find Mapper for provided id = " + id);
        }
        return mappers.get(id);
    }

    public abstract List<String> getPackagesToScan();

    public Buildable getBuildable(Request request) throws LegoSetException, ElementNotFoundException {
        PoseidonRequest poseidonRequest = (PoseidonRequest)request;
        Buildable buildable = this.buildableMap.get(poseidonRequest.getUrl());
        if (buildable == null) {
            throw new ElementNotFoundException("Buildable not found for given url: " + poseidonRequest.getUrl());
        }
        return buildable;
    }

    public void updateBuildables(Map<String, Buildable> buildableMap) {
        this.buildableMap = buildableMap;
    }

    public void setDataSourceExecutor(ExecutorService dataSourceExecutor) {
        this.dataSourceExecutor = dataSourceExecutor;
    }

    public ExecutorService getDataSourceExecutor() {
        return this.dataSourceExecutor;
    }
}

