/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.legoset;

import com.flipkart.poseidon.core.RequestContext;
import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ServerSpan;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import flipkart.lego.api.entities.DataSource;
import flipkart.lego.api.entities.DataType;
import java.util.List;
import java.util.Map;

public class ContextInducedDataSource
implements DataSource {
    private final DataSource dataSource;
    private final Map<String, Object> parentContext;
    private final HystrixRequestContext parentThreadState;
    private final ServerSpan serverSpan;

    public ContextInducedDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.parentContext = RequestContext.getContextMap();
        this.parentThreadState = HystrixRequestContext.getContextForCurrentThread();
        this.serverSpan = Brave.getServerSpanThreadBinder().getCurrentServerSpan();
    }

    public DataType call() throws Exception {
        HystrixRequestContext existingState = HystrixRequestContext.getContextForCurrentThread();
        try {
            RequestContext.initialize(this.parentContext);
            HystrixRequestContext.setContextOnCurrentThread((HystrixRequestContext)this.parentThreadState);
            if (this.serverSpan != null && this.serverSpan.getSpan() != null) {
                Brave.getServerSpanThreadBinder().setCurrentSpan(this.serverSpan);
            }
            DataType dataType = (DataType)this.dataSource.call();
            return dataType;
        }
        finally {
            RequestContext.shutDown();
            HystrixRequestContext.setContextOnCurrentThread((HystrixRequestContext)existingState);
            Brave.getServerSpanThreadBinder().setCurrentSpan(null);
        }
    }

    public String getId() throws UnsupportedOperationException {
        return this.dataSource.getId();
    }

    public String getName() throws UnsupportedOperationException {
        return this.dataSource.getName();
    }

    public List<Integer> getVersion() throws UnsupportedOperationException {
        return this.dataSource.getVersion();
    }

    public String getShortDescription() {
        return this.dataSource.getShortDescription();
    }

    public String getDescription() {
        return this.dataSource.getDescription();
    }
}

