/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.async;

import com.flipkart.poseidon.api.Application;
import com.flipkart.poseidon.api.Configuration;
import com.flipkart.poseidon.async.AsyncConsumerRequest;
import com.flipkart.poseidon.async.AsyncConsumerResult;
import com.flipkart.poseidon.async.AsyncResultState;
import com.flipkart.poseidon.core.PoseidonAsyncRequest;
import com.flipkart.poseidon.core.PoseidonRequest;
import com.flipkart.poseidon.core.PoseidonResponse;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PoseidonConsumer {
    private static final Logger logger = LoggerFactory.getLogger(PoseidonConsumer.class);
    private final Application application;
    private final Configuration configuration;

    public PoseidonConsumer(Application application, Configuration configuration) {
        this.application = application;
        this.configuration = configuration;
    }

    public final AsyncConsumerResult consume(AsyncConsumerRequest consumerRequest) {
        PoseidonAsyncRequest request = new PoseidonAsyncRequest(consumerRequest.getUrl(), Collections.emptyMap(), Collections.emptyMap(), consumerRequest.getParameters());
        request.setAttribute("poseidon.method", (Object)consumerRequest.getHttpMethod());
        request.setAttribute("body_bytes", (Object)consumerRequest.getPayload());
        try {
            PoseidonResponse response = new PoseidonResponse();
            this.application.handleRequest((PoseidonRequest)request, response);
            return new AsyncConsumerResult(AsyncResultState.SUCCESS);
        }
        catch (Throwable throwable) {
            logger.error("Unexpected exception while consuming async event", throwable);
            return new AsyncConsumerResult(AsyncResultState.FAILURE);
        }
    }
}

