/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.tracing;

import com.flipkart.poseidon.api.TracingConfiguration;
import com.flipkart.poseidon.core.RequestContext;
import com.github.kristofa.brave.FixedSampleRateTraceFilter;
import com.github.kristofa.brave.TraceFilter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicSampleRateTraceFilter
implements TraceFilter {
    private final TracingConfiguration tracingConfiguration;
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicSampleRateTraceFilter.class);
    private Map<String, TraceFilter> currentTraceFilterMap;

    public DynamicSampleRateTraceFilter(TracingConfiguration tracingConfiguration) {
        this.tracingConfiguration = tracingConfiguration;
    }

    public boolean trace(String requestName) {
        if (!this.isTracingEnabled() || requestName == null || requestName.isEmpty()) {
            RequestContext.set((String)"poseidon.enableTracing", (Object)false);
            return false;
        }
        Map<String, TraceFilter> traceFilterMap = this.getTraceFilterMap();
        for (Map.Entry<String, TraceFilter> entry : traceFilterMap.entrySet()) {
            String requestPattern = entry.getKey();
            TraceFilter traceFilter = entry.getValue();
            if ("*".equals(requestPattern)) {
                boolean enableTracing = traceFilter.trace(requestName);
                if (enableTracing) {
                    LOGGER.debug("Wildcard match. Tracing enabled for {}", (Object)requestName);
                } else {
                    LOGGER.debug("Wildcard match. Tracing not enabled for {}", (Object)requestName);
                }
                RequestContext.set((String)"poseidon.enableTracing", (Object)enableTracing);
                return enableTracing;
            }
            if (requestName.indexOf(requestPattern) <= -1) continue;
            boolean enableTracing = traceFilter.trace(requestName);
            if (enableTracing) {
                LOGGER.debug("Pattern match {}. Tracing enabled for {}", (Object)requestPattern, (Object)requestName);
            } else {
                LOGGER.debug("Pattern match {}. Tracing not enabled for {}", (Object)requestPattern, (Object)requestName);
            }
            RequestContext.set((String)"poseidon.enableTracing", (Object)enableTracing);
            return enableTracing;
        }
        LOGGER.debug("No pattern matched. Tracing not enabled for {}", (Object)requestName);
        RequestContext.set((String)"poseidon.enableTracing", (Object)false);
        return false;
    }

    public void close() {
    }

    private boolean isTracingEnabled() {
        boolean isTracingEnabled = this.tracingConfiguration.enableTracing();
        if (!isTracingEnabled && this.currentTraceFilterMap != null) {
            this.currentTraceFilterMap = null;
        }
        return isTracingEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, TraceFilter> getTraceFilterMap() {
        if (this.currentTraceFilterMap == null) {
            DynamicSampleRateTraceFilter dynamicSampleRateTraceFilter = this;
            synchronized (dynamicSampleRateTraceFilter) {
                if (this.currentTraceFilterMap == null && this.isTracingEnabled()) {
                    HashMap<String, TraceFilter> traceFilterMap = new HashMap<String, TraceFilter>();
                    Map<String, Integer> sampleRateMap = this.tracingConfiguration.getSampleRateMap();
                    if (sampleRateMap != null) {
                        for (Map.Entry<String, Integer> entry : sampleRateMap.entrySet()) {
                            String requestPattern = entry.getKey();
                            Integer sampleRate = entry.getValue();
                            if (sampleRate == null) continue;
                            traceFilterMap.put(requestPattern, (TraceFilter)new FixedSampleRateTraceFilter(sampleRate.intValue()));
                        }
                    }
                    this.currentTraceFilterMap = traceFilterMap;
                    LOGGER.debug("Reloaded URL sampling rate config with {} entries", (Object)this.currentTraceFilterMap.size());
                }
            }
        }
        return this.currentTraceFilterMap;
    }
}

