/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.filters;

import com.flipkart.poseidon.api.Configuration;
import com.flipkart.poseidon.api.HeaderConfiguration;
import com.flipkart.poseidon.core.RequestContext;
import com.flipkart.poseidon.serviceclients.ServiceContext;
import com.google.common.collect.ImmutableMap;
import com.netflix.hystrix.HystrixRequestLog;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class HystrixContextFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(HystrixContextFilter.class);
    private final Configuration configuration;

    public HystrixContextFilter(Configuration configuration) {
        this.configuration = configuration;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HystrixRequestContext hystrixRequestContext = HystrixRequestContext.initializeContext();
        this.initAllContext(request);
        try {
            chain.doFilter(request, response);
        }
        finally {
            this.logFailedHystrixCommands(request);
            this.shutdownAllContext(hystrixRequestContext);
        }
    }

    private void initAllContext(ServletRequest request) {
        RequestContext.initialize();
        ServiceContext.initialize();
        if (request instanceof HttpServletRequest) {
            this.setContext((HttpServletRequest)request);
        }
    }

    private void setContext(HttpServletRequest httpServletRequest) {
        RequestContext.set((String)"poseidon.method", (Object)httpServletRequest.getMethod());
        RequestContext.set((String)"sourceAddress", (Object)httpServletRequest.getRemoteAddr());
        if (this.configuration.getHeadersConfiguration() != null && this.configuration.getHeadersConfiguration().getGlobalHeaders() != null) {
            HashMap<String, String> headers = new HashMap<String, String>();
            for (HeaderConfiguration headerConfiguration : this.configuration.getHeadersConfiguration().getGlobalHeaders()) {
                String value = httpServletRequest.getHeader(headerConfiguration.getName());
                if (value == null) {
                    value = headerConfiguration.getDefaultValue();
                }
                if (value == null) continue;
                headers.put(headerConfiguration.getName(), value);
            }
            ImmutableMap immutableHeaders = ImmutableMap.copyOf(headers);
            ServiceContext.set((String)"headers", (Object)immutableHeaders);
            RequestContext.set((String)"poseidon.headers", (Object)immutableHeaders);
            MDC.setContextMap((Map)immutableHeaders);
        }
    }

    private void shutdownAllContext(HystrixRequestContext hystrixRequestContext) {
        RequestContext.shutDown();
        ServiceContext.shutDown();
        hystrixRequestContext.shutdown();
        MDC.clear();
    }

    public void destroy() {
    }

    private void logFailedHystrixCommands(ServletRequest request) {
        String url = ((HttpServletRequest)request).getPathInfo();
        Map globalHeaders = (Map)RequestContext.get((String)"poseidon.headers");
        HystrixRequestLog.getCurrentRequest().getAllExecutedCommands().stream().filter(command -> command.isResponseTimedOut() || command.isFailedExecution() || command.isResponseShortCircuited() || command.isResponseRejected()).forEach(command -> logger.error("URL: {}. Global headers: {}. Command: {}. Events: {}. Exception: {}", new Object[]{url, globalHeaders, command.getCommandKey().name(), command.getExecutionEvents(), command.getFailedExecutionException() == null ? "" : command.getFailedExecutionException().getMessage()}));
    }
}

