/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.filters;

import com.flipkart.poseidon.core.RequestContext;
import com.flipkart.poseidon.serviceclients.ServiceContext;
import com.netflix.hystrix.HystrixRequestLog;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixContextFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(HystrixContextFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HystrixRequestContext hystrixRequestContext = HystrixRequestContext.initializeContext();
        RequestContext.initialize();
        ServiceContext.initialize();
        try {
            chain.doFilter(request, response);
        }
        finally {
            this.logFailedHystrixCommands(request);
            RequestContext.shutDown();
            ServiceContext.shutDown();
            hystrixRequestContext.shutdown();
        }
    }

    public void destroy() {
    }

    private void logFailedHystrixCommands(ServletRequest request) {
        String url = ((HttpServletRequest)request).getPathInfo();
        Map globalHeaders = (Map)RequestContext.get((String)"poseidon.headers");
        HystrixRequestLog.getCurrentRequest().getAllExecutedCommands().stream().filter(command -> command.isResponseTimedOut() || command.isFailedExecution() || command.isResponseShortCircuited() || command.isResponseRejected()).forEach(command -> logger.error("URL: {}. Global headers: {}. Command: {}. Events: {}. Exception: ", new Object[]{url, globalHeaders, command.getCommandKey().name(), command.getExecutionEvents(), command.getFailedExecutionException()}));
    }
}

