/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.tracing;

import com.flipkart.phantom.event.consumer.PushToZipkinEventConsumer;
import com.flipkart.phantom.event.consumer.RequestLogger;
import com.flipkart.phantom.runtime.impl.jetty.filter.ServletTraceFilter;
import com.flipkart.phantom.task.impl.collector.DelegatingZipkinSpanCollector;
import com.flipkart.phantom.task.impl.collector.EventDispatchingSpanCollector;
import com.flipkart.poseidon.api.Configuration;
import com.flipkart.poseidon.api.TracingConfiguration;
import com.flipkart.poseidon.tracing.DynamicSampleRateTraceFilter;
import com.flipkart.poseidon.tracing.TraceHelper;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.TraceFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletTraceFilterBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletTraceFilterBuilder.class);

    public static ServletTraceFilter build(Configuration configuration) {
        TracingConfiguration tracingConfiguration = configuration.getTracingConfiguration();
        if (tracingConfiguration == null) {
            return null;
        }
        EventDispatchingSpanCollector eventDispatchingSpanCollector = TraceHelper.getSpanCollector();
        DynamicSampleRateTraceFilter traceFilter = new DynamicSampleRateTraceFilter(tracingConfiguration);
        ServletTraceFilter servletTraceFilter = new ServletTraceFilter();
        servletTraceFilter.setEventDispatchingSpanCollector(eventDispatchingSpanCollector);
        servletTraceFilter.setTraceFilter((TraceFilter)traceFilter);
        servletTraceFilter.setAppContextPath(configuration.getAppName());
        try {
            servletTraceFilter.afterPropertiesSet();
        }
        catch (Exception e) {
            LOGGER.error("Exception in afterPropertiesSet of ServletTraceFilter", (Throwable)e);
            return null;
        }
        String collectorHost = tracingConfiguration.getCollectorHost();
        int collectorPort = tracingConfiguration.getCollectorPort();
        DelegatingZipkinSpanCollector spanCollector = new DelegatingZipkinSpanCollector();
        spanCollector.setZipkinCollectorHost(collectorHost);
        spanCollector.setZipkinCollectorPort(collectorPort);
        RequestLogger requestLogger = (RequestLogger)TraceHelper.getBean((String)"commonRequestLogger", RequestLogger.class);
        PushToZipkinEventConsumer pushToZipkinEventConsumer = new PushToZipkinEventConsumer();
        pushToZipkinEventConsumer.setSpanCollector((SpanCollector)spanCollector);
        pushToZipkinEventConsumer.setRequestLogger(requestLogger);
        pushToZipkinEventConsumer.setSubscriptions(new String[]{"evt://com.flipkart.phantom.events.TRACING_COLLECTOR"});
        try {
            pushToZipkinEventConsumer.afterPropertiesSet();
        }
        catch (Exception e) {
            LOGGER.error("Exception in afterPropertiesSet of PushToZipkinEventConsumer", (Throwable)e);
            return null;
        }
        return servletTraceFilter;
    }
}

