/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.cadfael;

import com.flipkart.poseidon.cadfael.Cadfael;
import com.flipkart.poseidon.cadfael.artifact.NonVersionedArtifact;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;

@Mojo(name="cadfael")
public class Detect
extends AbstractMojo {
    @Parameter
    private Set<NonVersionedArtifact> nativeArtifacts = new HashSet<NonVersionedArtifact>();
    @Parameter
    private Set<NonVersionedArtifact> allowedDependencies = new HashSet<NonVersionedArtifact>();
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List repositories = this.project.getRemoteArtifactRepositories();
        this.getLog().info((CharSequence)("Found " + repositories.size() + " remote repositories."));
        this.getLog().info((CharSequence)"");
        HashSet<RemoteRepository> remoteRepositories = new HashSet<RemoteRepository>();
        for (ArtifactRepository repository : repositories) {
            remoteRepositories.add(new RemoteRepository.Builder(repository.getId(), "default", repository.getUrl()).build());
        }
        Cadfael cadfael = Cadfael.builder(remoteRepositories).allowedArtifacts(this.allowedDependencies).rejectSnapshots().ignoreTestScope().ignoreProvidedScope().build();
        List dependencies = this.project.getDependencies();
        this.getLog().info((CharSequence)("Found " + dependencies.size() + " dependencies."));
        this.getLog().info((CharSequence)"Verifying transitive dependencies.");
        this.getLog().info((CharSequence)"");
        boolean buildRejected = false;
        for (Object o : dependencies) {
            Dependency dependency = (Dependency)o;
            if (this.nativeArtifacts.contains(this.getNonVersionedArtifact(dependency))) continue;
            try {
                Set rejectedArtifacts = cadfael.getRejectedDependencies(this.getArtifact(dependency));
                if (rejectedArtifacts.size() <= 0) continue;
                this.getLog().error((CharSequence)("For " + dependency));
                this.getLog().error((CharSequence)(rejectedArtifacts.size() + " transitive dependencies have been rejected:"));
                for (Artifact artifact : rejectedArtifacts) {
                    this.getLog().error((CharSequence)artifact.toString());
                }
                this.getLog().error((CharSequence)"");
                buildRejected = true;
            }
            catch (ArtifactDescriptorException e) {
                throw new MojoExecutionException("Artifact not found", (Exception)((Object)e));
            }
        }
        if (buildRejected) {
            this.getLog().debug((CharSequence)"Allowed transitive dependencies:");
            for (NonVersionedArtifact artifact : this.allowedDependencies) {
                this.getLog().debug((CharSequence)artifact.toString());
            }
            throw new MojoExecutionException("There are rejected transitive dependencies. Clean your jar.");
        }
        this.getLog().info((CharSequence)"No transitive issues found.");
    }

    private Artifact getArtifact(Dependency dependency) {
        return new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), null, dependency.getVersion());
    }

    private NonVersionedArtifact getNonVersionedArtifact(Dependency dependency) {
        return new NonVersionedArtifact(dependency.getGroupId(), dependency.getArtifactId());
    }
}

