/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.validator;

import com.flipkart.poseidon.model.annotations.Description;
import com.flipkart.poseidon.model.annotations.Name;
import com.flipkart.poseidon.model.annotations.Version;
import flipkart.lego.api.entities.DataSource;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class AnnotationValidator {
    private static final List<Class<? extends Annotation>> annotationsToValidate = Arrays.asList(Name.class, Version.class, Description.class);

    public static List<String> validateDataSource(Class<? extends DataSource> dataSource) {
        ArrayList<String> errors = new ArrayList<String>();
        Predicate<Class> isAnnotationNotPresent = a -> !dataSource.isAnnotationPresent((Class<Annotation>)a);
        Consumer<Class> addToErrors = a -> errors.add(a.getSimpleName() + " annotation is missing.");
        annotationsToValidate.stream().filter(isAnnotationNotPresent).forEach(addToErrors);
        return errors;
    }
}

