/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.validator;

import com.flipkart.poseidon.pojos.ParamPOJO;
import com.flipkart.poseidon.pojos.ParamsPOJO;
import com.flipkart.poseidon.validator.ValidatorUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ParamValidator {
    private static final List<String> mutuallyExclusiveParamTypes = Arrays.asList("pathparam", "body", "header", "multivalue");

    public static List<String> validate(ParamsPOJO value, String url) throws IllegalAccessException {
        boolean containsPathParam;
        ArrayList<String> errors = new ArrayList<String>();
        errors.addAll(ParamValidator.getParamErrors(value.getRequired(), url));
        errors.addAll(ParamValidator.getParamErrors(value.getOptional(), url));
        errors.addAll(ParamValidator.detectDuplicateParams(value.getRequired(), value.getOptional()));
        if (value.getOptional() != null && (containsPathParam = Arrays.asList(value.getOptional()).stream().anyMatch(ParamPOJO::isPathparam))) {
            errors.add("Pathparam cannot be optional");
        }
        return errors;
    }

    private static List<String> getParamErrors(ParamPOJO[] params, String url) throws IllegalAccessException {
        ArrayList<String> errors = new ArrayList<String>();
        if (params != null && params.length > 0) {
            for (ParamPOJO param : params) {
                List<String> paramTypes = ParamValidator.getMarkedParamTypes(param);
                if (paramTypes.size() > 1) {
                    errors.add("Param: " + ValidatorUtils.braced(param.getName()) + " cannot be " + ValidatorUtils.getPrintableCSVs(paramTypes) + " at the same time");
                }
                if (param.isPathparam()) {
                    if (param.getPosition() <= 0) {
                        errors.add("Param: " + ValidatorUtils.braced(param.getName()) + " has been marked as pathparam, it needs a position as well");
                    } else if (url != null) {
                        if (url.charAt(0) == '/') {
                            url = url.substring(1);
                        }
                        String[] parts = url.split("/");
                        if (param.getPosition() > parts.length) {
                            errors.add("Invalid position for pathparam: " + ValidatorUtils.braced(param.getName()));
                        }
                    }
                }
                if (param.getDatatype() != null && param.getDatatype() == ParamPOJO.DataType.ENUM && (param.getType() == null || ValidatorUtils.isNullOrEmpty(param.getType().getType()))) {
                    errors.add("Param: " + ValidatorUtils.braced(param.getName()) + " does not have type defined for ENUM parameter");
                }
                if (!ValidatorUtils.isNullOrEmpty(param.getJavatype()) && param.getDatatype() != null && param.getDatatype() != ParamPOJO.DataType.ENUM) {
                    errors.add("Param: " + ValidatorUtils.braced(param.getName()) + " cannot have both datatype and javatype except for ENUM types");
                }
                if (!param.isBody() || param.getDatatype() == null) continue;
                errors.add("Param: " + ValidatorUtils.braced(param.getName()) + " is a body param, it cannot have a datatype");
            }
        }
        return errors;
    }

    public static List<String> getMarkedParamTypes(ParamPOJO param) throws IllegalAccessException {
        Field[] fields;
        ArrayList<String> marks = new ArrayList<String>();
        for (Field field : fields = ParamPOJO.class.getDeclaredFields()) {
            if (!Boolean.TYPE.isAssignableFrom(field.getType()) || !mutuallyExclusiveParamTypes.contains(field.getName())) continue;
            field.setAccessible(true);
            Boolean value = field.getBoolean(param);
            if (!value.booleanValue()) continue;
            marks.add(field.getName());
        }
        return marks;
    }

    public static List<String> detectDuplicateParams(ParamPOJO[] paramsOne, ParamPOJO[] paramsTwo) {
        ArrayList<String> errors = new ArrayList<String>();
        if (paramsOne != null && paramsTwo != null) {
            for (ParamPOJO paramOne : paramsOne) {
                for (ParamPOJO paramTwo : paramsTwo) {
                    if (paramOne.getName() == null || paramTwo.getName() == null || !paramOne.getName().equalsIgnoreCase(paramTwo.getName())) continue;
                    errors.add("Param: " + ValidatorUtils.braced(paramOne.getName()) + " exists as both required and optional parameter");
                }
            }
        }
        return errors;
    }
}

