/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.api;

import com.fasterxml.jackson.databind.JavaType;
import com.flipkart.hydra.task.Task;
import com.flipkart.poseidon.api.Configuration;
import com.flipkart.poseidon.core.PoseidonResponse;
import com.flipkart.poseidon.handlers.http.utils.StringUtils;
import com.flipkart.poseidon.internal.OrchestratorDataSource;
import com.flipkart.poseidon.internal.ParamValidationFilter;
import com.flipkart.poseidon.legoset.PoseidonLegoSet;
import com.flipkart.poseidon.mappers.Mapper;
import com.flipkart.poseidon.model.VariableModel;
import com.flipkart.poseidon.pojos.EndpointPOJO;
import com.flipkart.poseidon.pojos.ParamPOJO;
import com.google.common.net.MediaType;
import flipkart.lego.api.entities.Buildable;
import flipkart.lego.api.entities.DataSource;
import flipkart.lego.api.entities.Filter;
import flipkart.lego.api.entities.LegoSet;
import flipkart.lego.api.entities.Request;
import flipkart.lego.api.entities.Response;
import flipkart.lego.api.exceptions.ElementNotFoundException;
import flipkart.lego.api.exceptions.InternalErrorException;
import flipkart.lego.api.exceptions.LegoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class APIBuildable
implements Buildable {
    private static final String RESPONSE_KEY = "response_key";
    private final PoseidonLegoSet legoSet;
    private final EndpointPOJO pojo;
    private final Configuration configuration;
    private final Map<String, Task> tasks;
    private List<Object> mappedBeans;

    public APIBuildable(PoseidonLegoSet legoSet, EndpointPOJO pojo, Configuration configuration, Map<String, Task> tasks) {
        this.legoSet = legoSet;
        this.pojo = pojo;
        this.configuration = configuration;
        this.tasks = tasks;
        if (pojo.getParams() != null) {
            this.loadJavaTypes(pojo.getParams().getRequired());
            this.loadJavaTypes(pojo.getParams().getOptional());
        }
    }

    public long getTimeout() throws LegoException {
        return this.pojo.getTimeout();
    }

    public Map<String, DataSource> getRequiredDataSources(Request request) throws InternalErrorException {
        Map initialParams = (Map)request.getAttribute("params");
        this.mappedBeans = new ArrayList<Object>();
        OrchestratorDataSource dataSource = new OrchestratorDataSource((LegoSet)this.legoSet, initialParams, this.tasks, this.pojo.getResponse(), this.getMappers(), this.mappedBeans);
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
        dataSourceMap.put(RESPONSE_KEY, this.legoSet.wrapDataSource((DataSource)dataSource, request));
        return dataSourceMap;
    }

    public Map<String, DataSource> getOptionalDataSources(Request request) throws LegoException {
        return null;
    }

    public void build(Request request, Response response, Map<String, Object> model) throws InternalErrorException {
        PoseidonResponse poseidonResponse = (PoseidonResponse)response;
        poseidonResponse.setContentType(MediaType.JSON_UTF_8);
        poseidonResponse.addMappedBeans(this.mappedBeans);
        Object dsResponse = model.get(RESPONSE_KEY);
        poseidonResponse.setResponse(dsResponse);
    }

    public LinkedHashSet<Filter> getFilters(Request request) throws InternalErrorException {
        LinkedHashSet<Filter> filters = new LinkedHashSet<Filter>();
        filters.add(this.legoSet.wrapFilter((Filter)new ParamValidationFilter(this.pojo.getParams(), this.configuration)));
        try {
            if (this.configuration.getFilterIds() != null) {
                for (String filterId : this.configuration.getFilterIds()) {
                    filters.add(this.legoSet.getFilter(filterId));
                }
            }
            if (this.pojo.getFilters() != null) {
                for (String filterId : this.pojo.getFilters()) {
                    filters.add(this.legoSet.getFilter(filterId));
                }
            }
        }
        catch (ElementNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return filters;
    }

    private LinkedHashSet<Mapper> getMappers() throws InternalErrorException {
        LinkedHashSet<Mapper> mappers = new LinkedHashSet<Mapper>();
        try {
            if (this.pojo.getMappers() != null) {
                for (String mapperId : this.pojo.getMappers()) {
                    mappers.add(this.legoSet.getMapper(mapperId));
                }
            }
        }
        catch (ElementNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return mappers;
    }

    public EndpointPOJO getPojo() {
        return this.pojo;
    }

    private void loadJavaTypes(ParamPOJO[] params) {
        if (params == null) {
            return;
        }
        for (ParamPOJO param : params) {
            Object javaType = param.getType() != null ? this.constructJavaType(param.getType()) : (!StringUtils.isNullOrEmpty((String)param.getJavatype()) ? this.constructJavaType(new VariableModel(param.getJavatype())) : null);
            param.setJavaType((JavaType)javaType);
        }
    }

    private JavaType constructJavaType(VariableModel variableModel) {
        Class<?> clazz;
        try {
            clazz = Class.forName(variableModel.getType());
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Specify a known class " + variableModel.getType(), e);
        }
        JavaType[] javaTypes = new JavaType[variableModel.getTypes().length];
        for (int i = 0; i < variableModel.getTypes().length; ++i) {
            javaTypes[i] = this.constructJavaType(variableModel.getTypes()[i]);
        }
        return this.configuration.getObjectMapper().getTypeFactory().constructParametrizedType(clazz, clazz, javaTypes);
    }
}

