/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.validator;

import com.flipkart.poseidon.pojos.ParamPOJO;
import com.flipkart.poseidon.pojos.ParamsPOJO;
import com.flipkart.poseidon.pojos.TaskPOJO;
import com.flipkart.poseidon.validator.ValidatorUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TaskValidator {
    public static List<String> validate(Map<String, TaskPOJO> tasks, ParamsPOJO params) {
        ArrayList<String> errors = new ArrayList<String>();
        for (Map.Entry<String, TaskPOJO> entry : tasks.entrySet()) {
            String taskName = entry.getKey();
            TaskPOJO task = entry.getValue();
            if (ValidatorUtils.isNullOrEmpty(task.getName())) {
                errors.add("No datasource defined for Task: " + ValidatorUtils.braced(taskName));
            }
            Map context = Optional.ofNullable(task.getContext()).orElse(new HashMap());
            for (Map.Entry contextEntry : context.entrySet()) {
                boolean isExpression;
                boolean isOptional;
                Object contextEntryValue = contextEntry.getValue();
                if (!(contextEntryValue instanceof String)) continue;
                String fullContextParam = ValidatorUtils.stripBraces((String)contextEntryValue);
                boolean bl = isOptional = fullContextParam.charAt(0) == '#';
                if (isOptional) {
                    fullContextParam = fullContextParam.substring(1);
                }
                if (!(isExpression = fullContextParam.charAt(0) == '$')) continue;
                fullContextParam = fullContextParam.substring(1);
                String contextParam = fullContextParam.split("\\.")[0];
                boolean located = false;
                if (contextParam == null || contextParam.isEmpty()) continue;
                if (params != null) {
                    if (params.getRequired() != null) {
                        for (ParamPOJO param : params.getRequired()) {
                            if (!contextParam.equals(param.getName()) && !contextParam.equals(param.getInternalName())) continue;
                            located = true;
                            if (!isOptional) continue;
                            errors.add("Param: " + ValidatorUtils.braced(param.getName()) + " used in Task: " + ValidatorUtils.braced(taskName) + " is not optional");
                        }
                    }
                    if (params.getOptional() != null) {
                        for (ParamPOJO param : params.getOptional()) {
                            if (!contextParam.equals(param.getName()) && !contextParam.equals(param.getInternalName())) continue;
                            located = true;
                            if (isOptional || param.getDefaultValue() != null) continue;
                            errors.add("Param: " + ValidatorUtils.braced(param.getName()) + " used in Task: " + ValidatorUtils.braced(taskName) + " is optional. Add a '#'");
                        }
                    }
                }
                for (String param : tasks.keySet()) {
                    if (!contextParam.equals(param)) continue;
                    located = true;
                }
                if (located && !contextParam.equals(taskName)) continue;
                errors.add("Param: " + ValidatorUtils.braced(contextParam) + " used in Task: " + ValidatorUtils.braced(taskName) + " is not defined anywhere");
            }
        }
        return errors;
    }
}

