/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.validator;

import com.flipkart.poseidon.helper.ClassPathHelper;
import com.flipkart.poseidon.validator.AnnotationValidator;
import com.flipkart.poseidon.validator.CustomBlocksValidator;
import com.flipkart.poseidon.validator.DatasourceValidator;
import com.flipkart.poseidon.validator.ValidatorUtils;
import com.google.common.reflect.ClassPath;
import flipkart.lego.api.entities.DataSource;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlocksValidator {
    private static final Logger logger = LoggerFactory.getLogger(BlocksValidator.class);

    public static void main(String[] args) {
        try {
            String customValidatorClass = System.getProperty("poseidon.validator.block.custom");
            CustomBlocksValidator customValidator = null;
            if (StringUtils.isNotEmpty((CharSequence)customValidatorClass)) {
                try {
                    Class<?> aClass = Class.forName(customValidatorClass);
                    Object constructedInstance = aClass.newInstance();
                    if (!(constructedInstance instanceof CustomBlocksValidator)) {
                        throw new IllegalArgumentException("Wrong class supplied");
                    }
                    customValidator = (CustomBlocksValidator)constructedInstance;
                }
                catch (Exception e) {
                    logger.error("Wrong CustomBlockValidator passed", (Throwable)e);
                    System.exit(-1);
                }
            }
            Set classInfos = ClassPathHelper.getPackageClasses((ClassLoader)Thread.currentThread().getContextClassLoader(), Arrays.asList(args));
            System.out.println("Classes in ClassLoader: " + classInfos.size());
            HashMap<String, List<String>> errors = new HashMap<String, List<String>>();
            for (ClassPath.ClassInfo classInfo : classInfos) {
                Class<?> clazz = Class.forName(classInfo.getName());
                if (Modifier.isAbstract(clazz.getModifiers())) continue;
                ArrayList<String> classErrors = new ArrayList<String>();
                if (DataSource.class.isAssignableFrom(clazz)) {
                    classErrors.addAll(AnnotationValidator.validateDataSource(clazz));
                    classErrors.addAll(DatasourceValidator.validate(clazz));
                    if (customValidator != null) {
                        classErrors.addAll(customValidator.validateDatasource(clazz));
                    }
                }
                if (classErrors.isEmpty()) continue;
                errors.put(clazz.getName(), classErrors);
            }
            if (!errors.isEmpty()) {
                logger.error(ValidatorUtils.getFormattedErrorMessages(errors));
                System.exit(-1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

