/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.validator;

import com.flipkart.poseidon.helper.ClassPathHelper;
import com.flipkart.poseidon.validator.AnnotationValidator;
import com.flipkart.poseidon.validator.ValidatorUtils;
import com.google.common.reflect.ClassPath;
import flipkart.lego.api.entities.DataSource;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlocksValidator {
    private static final Logger logger = LoggerFactory.getLogger(BlocksValidator.class);

    public static void main(String[] args) {
        try {
            Set classInfos = ClassPathHelper.getPackageClasses((ClassLoader)Thread.currentThread().getContextClassLoader(), Arrays.asList(args));
            System.out.println("Classes in ClassLoader: " + classInfos.size());
            HashMap<String, List<String>> errors = new HashMap<String, List<String>>();
            for (ClassPath.ClassInfo classInfo : classInfos) {
                List<String> annotationErrors;
                Class<DataSource> clazz = Class.forName(classInfo.getName());
                if (Modifier.isAbstract(clazz.getModifiers()) || !DataSource.class.isAssignableFrom(clazz) || (annotationErrors = AnnotationValidator.validateDataSource(clazz)).isEmpty()) continue;
                errors.put(clazz.getName(), annotationErrors);
            }
            if (!errors.isEmpty()) {
                logger.error(ValidatorUtils.getFormattedErrorMessages(errors));
                System.exit(-1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

