/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.ds.trie;

import com.flipkart.poseidon.ds.trie.KeyWrapper;
import com.flipkart.poseidon.ds.trie.TrieNode;
import java.util.ArrayList;
import java.util.List;

public class Trie<K, V> {
    private TrieNode<K, V> root = new TrieNode();

    public void add(List<KeyWrapper<K>> keys, V value) {
        if (this.root.firstChild == null) {
            this.addChainAsFirstChild(this.root, keys, value);
            return;
        }
        TrieNode currentNode = this.root.firstChild;
        TrieNode currentParent = this.root;
        for (int i = 0; i < keys.size(); ++i) {
            TrieNode matchingNode = this.findMatchingNode(currentNode, keys.get(i));
            if (matchingNode == null) {
                TrieNode newNode = new TrieNode();
                newNode.key = keys.get((int)i).key;
                newNode.matchAny = keys.get((int)i).wildCard;
                newNode.greedyMatchAny = keys.get((int)i).greedyWildCard;
                Object object = newNode.value = i == keys.size() - 1 ? value : null;
                if (currentNode == null) {
                    currentParent.firstChild = newNode;
                    if (newNode.matchAny) {
                        currentParent.wildChild = newNode;
                    } else if (newNode.greedyMatchAny) {
                        currentParent.greedyWildChild = newNode;
                    }
                } else if (!newNode.matchAny && !newNode.greedyMatchAny) {
                    newNode.rightSibling = currentParent.firstChild;
                    currentParent.firstChild = newNode;
                } else if (newNode.matchAny) {
                    if (currentNode.greedyMatchAny) {
                        newNode.rightSibling = currentNode;
                        currentParent.firstChild = newNode;
                    } else {
                        while (currentNode.rightSibling != null && !currentNode.rightSibling.greedyMatchAny) {
                            currentNode = currentNode.rightSibling;
                        }
                        if (currentNode.rightSibling != null && currentNode.rightSibling.greedyMatchAny) {
                            newNode.rightSibling = currentNode.rightSibling;
                            currentNode.rightSibling = newNode;
                        } else {
                            currentNode.rightSibling = newNode;
                        }
                        currentParent.wildChild = newNode;
                    }
                } else if (newNode.greedyMatchAny) {
                    if (currentNode.matchAny) {
                        currentParent.rightSibling = newNode;
                    } else {
                        while (currentNode.rightSibling != null) {
                            currentNode = currentNode.rightSibling;
                        }
                        currentNode.rightSibling = newNode;
                        currentParent.greedyWildChild = newNode;
                    }
                }
                this.addChainAsFirstChild(newNode, keys.subList(i + 1, keys.size()), value);
                return;
            }
            currentParent = matchingNode;
            currentNode = matchingNode.firstChild;
            matchingNode.value = i == keys.size() - 1 ? value : matchingNode.value;
        }
    }

    private TrieNode findMatchingNode(TrieNode node, KeyWrapper<K> wrapper) {
        if (node == null) {
            return null;
        }
        TrieNode correctNode = null;
        if (node.matchAny && wrapper.wildCard || node.greedyMatchAny && wrapper.greedyWildCard || !node.matchAny && !node.greedyMatchAny && node.key.equals(wrapper.key)) {
            correctNode = node;
        } else {
            TrieNode current = node.rightSibling;
            while (current != null) {
                if (current.matchAny && wrapper.wildCard || current.greedyMatchAny && wrapper.greedyWildCard || !current.matchAny && !current.greedyMatchAny && current.key.equals(wrapper.key)) {
                    correctNode = current;
                    break;
                }
                current = current.rightSibling;
            }
        }
        return correctNode;
    }

    private void addChainAsFirstChild(TrieNode node, List<KeyWrapper<K>> keys, V value) {
        TrieNode currentNode = node;
        for (int i = 0; i < keys.size(); ++i) {
            TrieNode newNode = new TrieNode();
            newNode.key = keys.get((int)i).key;
            newNode.matchAny = keys.get((int)i).wildCard;
            newNode.greedyMatchAny = keys.get((int)i).greedyWildCard;
            newNode.value = i == keys.size() - 1 ? value : null;
            currentNode.firstChild = newNode;
            if (newNode.matchAny) {
                currentNode.wildChild = newNode;
            } else if (newNode.greedyMatchAny) {
                currentNode.greedyWildChild = newNode;
            }
            currentNode = currentNode.firstChild;
        }
    }

    public V get(K[] keys) {
        return this.get(this.root, 0, keys);
    }

    private V get(TrieNode<K, V> node, int level, K[] keys) {
        V value = null;
        if (node != null) {
            TrieNode matchingChild = node.firstChild;
            TrieNode wildChild = node.wildChild;
            TrieNode wildPathChild = node.greedyWildChild;
            while (!(matchingChild == null || matchingChild.matchAny || matchingChild.greedyMatchAny || matchingChild.key.equals(keys[level]))) {
                matchingChild = matchingChild.rightSibling;
            }
            if (matchingChild == null) {
                return null;
            }
            value = level == keys.length - 1 ? (V)matchingChild.value : (V)this.get(matchingChild, level + 1, keys);
            if (value == null && !matchingChild.matchAny && !matchingChild.greedyMatchAny && wildChild != null) {
                value = level == keys.length - 1 ? (V)wildChild.value : (V)this.get(wildChild, level + 1, keys);
            }
            if (value == null && wildPathChild != null) {
                if (wildPathChild.firstChild == null) {
                    value = wildPathChild.value;
                } else {
                    for (int i = level + 1; i < keys.length; ++i) {
                        TrieNode currentLookUp = this.findMatch(wildPathChild.firstChild, keys[i]);
                        if (currentLookUp == null) continue;
                        if (i == keys.length - 1) {
                            value = currentLookUp.value;
                            break;
                        }
                        value = this.get(currentLookUp, i + 1, keys);
                        break;
                    }
                    if (value == null) {
                        value = wildPathChild.value;
                    }
                }
            }
        }
        return value;
    }

    public TrieNode<K, V> findMatch(TrieNode<K, V> node, K key) {
        if (node.matchAny || node.greedyMatchAny || node.key.equals(key)) {
            return node;
        }
        TrieNode current = node.rightSibling;
        while (current != null) {
            if (current.matchAny || current.greedyMatchAny || current.key.equals(key)) {
                return current;
            }
            current = current.rightSibling;
        }
        return null;
    }

    public List<List<String>> printAllPaths(String separator) {
        ArrayList<List<String>> paths = new ArrayList<List<String>>();
        this.traverseAndPrint(this.root, new ArrayList<String>(), separator, paths);
        return paths;
    }

    private void traverseAndPrint(TrieNode<K, V> node, List<String> pathStr, String separator, List<List<String>> paths) {
        if (node == null) {
            return;
        }
        ArrayList<String> pathParts = new ArrayList<String>(pathStr);
        if (!pathStr.isEmpty() && !separator.equals(pathStr.get(pathStr.size() - 1))) {
            pathParts.add(separator);
        }
        if (node.key != null) {
            pathParts.add(node.key.toString());
        }
        if (node.matchAny) {
            pathParts.add("{}");
        }
        if (node.greedyMatchAny) {
            pathParts.add("**");
        }
        if (node.value != null) {
            paths.add(pathParts);
        }
        this.traverseAndPrint(node.firstChild, pathParts, separator, paths);
        this.traverseAndPrint(node.rightSibling, pathStr, separator, paths);
    }
}

