/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.validator;

import com.flipkart.poseidon.api.APIManager;
import com.flipkart.poseidon.helpers.ObjectMapperHelper;
import com.flipkart.poseidon.pojos.EndpointPOJO;
import com.flipkart.poseidon.validator.EndpointValidator;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIValidator {
    private static final Logger logger = LoggerFactory.getLogger(APIValidator.class);
    private static final List<EndpointPOJO> pojos = new ArrayList<EndpointPOJO>();

    public static void main(String[] args) {
        Path dir = Paths.get(args[0], new String[0]);
        ArrayList<String> validConfigs = new ArrayList<String>();
        try {
            APIManager.scanAndAdd(dir, validConfigs);
            for (String config : validConfigs) {
                pojos.add((EndpointPOJO)ObjectMapperHelper.getMapper().readValue(config, EndpointPOJO.class));
            }
            HashMap<String, List<String>> errors = new HashMap<String, List<String>>();
            for (EndpointPOJO endpointPOJO : pojos) {
                List<String> pojoErrors = EndpointValidator.validate(endpointPOJO);
                if (pojoErrors.isEmpty()) continue;
                errors.put(endpointPOJO.getHttpMethod() + " " + endpointPOJO.getUrl(), pojoErrors);
            }
            if (!errors.isEmpty()) {
                for (Map.Entry entry : errors.entrySet()) {
                    logger.error("--------------------------------------------");
                    logger.error("Errors while validating " + (String)entry.getKey());
                    logger.error("--------------------------------------------");
                    ((List)entry.getValue()).forEach(arg_0 -> ((Logger)logger).error(arg_0));
                    logger.error("");
                }
                System.exit(-1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

