/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.ds.trie;

import com.flipkart.poseidon.ds.trie.TrieNode;
import java.util.Arrays;

public class Trie<K, V> {
    private TrieNode<K, V> root = new TrieNode();

    public void add(K[] keys, V value) {
        if (this.root.firstChild == null) {
            this.addChainAsFirstChild(this.root, keys, value);
            return;
        }
        TrieNode currentNode = this.root.firstChild;
        TrieNode currentParent = this.root;
        for (int i = 0; i < keys.length; ++i) {
            TrieNode matchingNode = this.findMatchingNode(currentNode, keys[i]);
            if (matchingNode == null) {
                TrieNode newNode = new TrieNode();
                newNode.key = keys[i];
                newNode.matchAny = keys[i] == null;
                Object object = newNode.value = i == keys.length - 1 ? value : null;
                if (newNode.key != null) {
                    newNode.rightSibling = currentParent.firstChild;
                    currentParent.firstChild = newNode;
                } else {
                    while (currentNode.rightSibling != null) {
                        currentNode = currentNode.rightSibling;
                    }
                    currentNode.rightSibling = newNode;
                    currentParent.wildChild = newNode;
                }
                this.addChainAsFirstChild(newNode, Arrays.copyOfRange(keys, i + 1, keys.length), value);
                return;
            }
            currentParent = matchingNode;
            currentNode = matchingNode.firstChild;
            matchingNode.value = i == keys.length - 1 ? value : matchingNode.value;
        }
    }

    private TrieNode findMatchingNode(TrieNode node, K key) {
        if (node == null) {
            return null;
        }
        TrieNode correctNode = null;
        if (node.matchAny && key == null || !node.matchAny && node.key.equals(key)) {
            correctNode = node;
        } else {
            TrieNode current = node.rightSibling;
            while (current != null) {
                if (current.matchAny && key == null || !current.matchAny && current.key.equals(key)) {
                    correctNode = current;
                    break;
                }
                current = current.rightSibling;
            }
        }
        return correctNode;
    }

    private void addChainAsFirstChild(TrieNode node, K[] keys, V value) {
        TrieNode currentNode = node;
        for (int i = 0; i < keys.length; ++i) {
            TrieNode newNode = new TrieNode();
            newNode.key = keys[i];
            newNode.matchAny = keys[i] == null;
            newNode.value = i == keys.length - 1 ? value : null;
            currentNode.firstChild = newNode;
            if (newNode.matchAny) {
                currentNode.wildChild = newNode;
            }
            currentNode = currentNode.firstChild;
        }
    }

    public V get(K[] keys) {
        return this.get(this.root, 0, keys);
    }

    private V get(TrieNode<K, V> node, int level, K[] keys) {
        V value = null;
        if (node != null) {
            TrieNode matchingChild = node.firstChild;
            TrieNode wildChild = node.wildChild;
            while (matchingChild != null && !matchingChild.matchAny && !matchingChild.key.equals(keys[level])) {
                matchingChild = matchingChild.rightSibling;
            }
            if (matchingChild == null) {
                return null;
            }
            value = level == keys.length - 1 ? (V)matchingChild.value : (V)this.get(matchingChild, level + 1, keys);
            if (value == null && !matchingChild.matchAny && wildChild != null) {
                value = level == keys.length - 1 ? (V)wildChild.value : (V)this.get(wildChild, level + 1, keys);
            }
        }
        return value;
    }

    public void printAllPaths(String separator) {
        this.traverseAndPrint(this.root, "", separator);
    }

    private void traverseAndPrint(TrieNode<K, V> node, String pathStr, String separator) {
        if (node == null) {
            return;
        }
        StringBuilder strBuilder = new StringBuilder(pathStr);
        if (!pathStr.endsWith(separator)) {
            strBuilder.append(separator);
        }
        if (node.key != null) {
            strBuilder.append(node.key);
        }
        if (node.matchAny) {
            strBuilder.append("*");
        }
        if (node.value != null) {
            System.out.println(strBuilder);
        }
        this.traverseAndPrint(node.firstChild, strBuilder.toString(), separator);
        this.traverseAndPrint(node.rightSibling, pathStr, separator);
    }
}

