/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.ds.trie;

import com.flipkart.poseidon.ds.trie.TrieNode;

public class Trie<K, V> {
    private TrieNode<K, V> root = new TrieNode();

    public void add(K[] keys, V value) {
        Boolean EXIT_STATUS = false;
        int noOfParts = keys.length - 1;
        int currPosition = 0;
        TrieNode currNode = this.root.firstChild;
        TrieNode<K, V> prevNode = this.root;
        Boolean insertAsrightSibling = false;
        while (!EXIT_STATUS.booleanValue() && currPosition <= noOfParts) {
            if (currNode == null) {
                for (int pos = currPosition; pos <= noOfParts; ++pos) {
                    if (!insertAsrightSibling.booleanValue()) {
                        currNode = prevNode.firstChild = new TrieNode();
                        currNode.parent = prevNode;
                    } else {
                        prevNode.rightSibling = new TrieNode();
                        currNode = prevNode.rightSibling;
                        currNode.parent = prevNode;
                        insertAsrightSibling = false;
                    }
                    currNode.key = keys[pos];
                    if (currNode.key == null) {
                        currNode.matchAll = true;
                    }
                    if (pos == noOfParts) {
                        currNode.value = value;
                    }
                    if (currNode.parent.matchAll && currNode.parent.rightSibling == currNode) {
                        currNode.parent = prevNode.parent;
                        if (prevNode == prevNode.parent.rightSibling) {
                            prevNode.parent.rightSibling = currNode;
                        } else {
                            prevNode.parent.firstChild = currNode;
                        }
                        prevNode.rightSibling = null;
                        currNode.rightSibling = prevNode;
                        prevNode.parent = currNode;
                    }
                    prevNode = currNode;
                    currNode = currNode.firstChild;
                    ++currPosition;
                }
                EXIT_STATUS = true;
                continue;
            }
            if (currNode.key == null && keys[currPosition] == null || currNode.key != null && currNode.key.equals(keys[currPosition])) {
                if (currPosition == noOfParts) {
                    currNode.value = value;
                    EXIT_STATUS = true;
                    continue;
                }
                ++currPosition;
                prevNode = currNode;
                currNode = currNode.firstChild;
                insertAsrightSibling = false;
                continue;
            }
            prevNode = currNode;
            currNode = currNode.rightSibling;
            insertAsrightSibling = true;
        }
    }

    public V get(K[] keys) {
        return this.get(this.root.firstChild, 0, keys);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private V get(TrieNode<K, V> node, int level, K[] keys) {
        V value = null;
        if (node == null) return value;
        if (node.matchAll || node.key.equals(keys[level])) {
            if (level == keys.length - 1) {
                value = node.value;
            } else if (level < keys.length - 1) {
                value = this.get(node.firstChild, level + 1, keys);
            }
            if (value != null) return value;
            TrieNode<K, V> currentNode = node;
            TrieNode nextNode = node.rightSibling;
            while (nextNode != null) {
                currentNode = nextNode;
                nextNode = nextNode.rightSibling;
            }
            if (!currentNode.matchAll) return value;
            value = level == keys.length - 1 ? (V)node.value : (V)this.get(node.firstChild, level + 1, keys);
            return value;
        } else {
            value = this.get(node.rightSibling, level, keys);
        }
        return value;
    }

    public void printAllPaths(String separator) {
        this.traverseAndPrint(this.root, "", separator);
    }

    private void traverseAndPrint(TrieNode<K, V> node, String pathStr, String separator) {
        if (node == null) {
            return;
        }
        StringBuilder strBuilder = new StringBuilder(pathStr);
        if (!pathStr.endsWith(separator)) {
            strBuilder.append(separator);
        }
        if (node.key != null) {
            strBuilder.append(node.key);
        }
        if (node.matchAll) {
            strBuilder.append("*");
        }
        if (node.value != null) {
            System.out.println(strBuilder);
        }
        this.traverseAndPrint(node.firstChild, strBuilder.toString(), separator);
        this.traverseAndPrint(node.rightSibling, pathStr, separator);
    }
}

