/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.api;

import com.flipkart.poseidon.core.PoseidonRequest;
import com.flipkart.poseidon.ds.trie.Trie;
import com.flipkart.poseidon.legoset.PoseidonLegoSet;
import com.flipkart.poseidon.metrics.Metrics;
import com.flipkart.poseidon.utils.ApiHelper;
import flipkart.lego.api.entities.Buildable;
import flipkart.lego.api.entities.Request;
import flipkart.lego.api.exceptions.ElementNotFoundException;
import flipkart.lego.api.exceptions.LegoSetException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class APILegoSet
extends PoseidonLegoSet {
    private static final Logger logger = LoggerFactory.getLogger(APILegoSet.class);
    private Trie<String, Buildable> trie = new Trie();

    public void updateBuildables(Map<String, Buildable> buildableMap) {
        for (Map.Entry<String, Buildable> entry : buildableMap.entrySet()) {
            String url = entry.getKey();
            String[] keys = this.getKeysForTrie(url);
            for (int i = 0; i < keys.length; ++i) {
                if (!keys[i].startsWith("{") || !keys[i].endsWith("}")) continue;
                keys[i] = null;
            }
            this.trie.add((String[])keys, entry.getValue());
        }
        logger.info("Registered URLs: ");
        this.trie.printAllPaths("/");
    }

    public Buildable getBuildable(Request request) throws LegoSetException, ElementNotFoundException {
        PoseidonRequest poseidonRequest = (PoseidonRequest)request;
        String httpMethod = poseidonRequest.getAttribute("method").toString();
        String completeUrl = ApiHelper.getUrlWithHttpMethod(poseidonRequest.getUrl(), httpMethod);
        Buildable buildable = this.trie.get((String[])this.getKeysForTrie(completeUrl));
        if (buildable == null && (buildable = this.trie.get((String[])this.getKeysForTrie(poseidonRequest.getUrl()))) == null) {
            throw new ElementNotFoundException("Buildable not found for given url: " + poseidonRequest.getUrl());
        }
        String name = buildable.getName();
        if (name != null && !name.isEmpty()) {
            poseidonRequest.setAttribute("timerContext", (Object)Metrics.getRegistry().timer("poseidon.api." + name + "." + httpMethod).time());
        }
        return buildable;
    }

    private String[] getKeysForTrie(String url) {
        if (url.startsWith("/")) {
            url = url.replaceFirst("\\/", "");
        }
        return url.split("/");
    }
}

