/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.internal;

import com.flipkart.hydra.composer.Composer;
import com.flipkart.hydra.composer.DefaultComposer;
import com.flipkart.hydra.composer.exception.ComposerEvaluationException;
import com.flipkart.hydra.composer.exception.ComposerInstantiationException;
import com.flipkart.hydra.task.DefaultMultiTask;
import com.flipkart.hydra.task.exception.BadCallableException;
import com.flipkart.poseidon.datasources.DataSourceRequest;
import com.flipkart.poseidon.internal.DataSourceCallable;
import com.flipkart.poseidon.legoset.PoseidonLegoSet;
import flipkart.lego.api.entities.DataSource;
import flipkart.lego.api.entities.Request;
import flipkart.lego.api.exceptions.ElementNotFoundException;
import flipkart.lego.api.exceptions.LegoSetException;
import java.util.Map;
import java.util.concurrent.Callable;

public class APITask
extends DefaultMultiTask {
    private final PoseidonLegoSet legoSet;
    private final String name;

    public APITask(PoseidonLegoSet legoSet, String name, String loopOverContext, Map<String, Object> context) throws ComposerInstantiationException {
        super(legoSet.getDataSourceExecutor(), null, (Composer)new DefaultComposer(context), (Composer)(loopOverContext == null ? null : new DefaultComposer((Object)loopOverContext)));
        this.legoSet = legoSet;
        this.name = name;
    }

    public Callable getCallable(Map<String, Object> values) throws BadCallableException {
        if (this.loopComposer == null) {
            return this.getDataSource(values);
        }
        try {
            return new DataSourceCallable(this.legoSet, this.executor, this.name, this.loopComposer, this.composer, values);
        }
        catch (ComposerEvaluationException | NoSuchMethodException e) {
            throw new BadCallableException("Unable to execute callable", e);
        }
    }

    private DataSource getDataSource(Map<String, Object> values) throws BadCallableException {
        try {
            Map composedValues = (Map)this.composer.compose(values);
            DataSourceRequest dataSourceRequest = this.getDataSourceRequest(composedValues);
            return this.legoSet.getDataSource(this.name, (Request)dataSourceRequest);
        }
        catch (ComposerEvaluationException | ElementNotFoundException | LegoSetException e) {
            throw new BadCallableException("Unable to find datasource - " + this.name, e);
        }
    }

    private DataSourceRequest getDataSourceRequest(Map<String, Object> values) {
        DataSourceRequest dataSourceRequest = new DataSourceRequest();
        for (String key : values.keySet()) {
            dataSourceRequest.setAttribute(key, values.get(key));
        }
        return dataSourceRequest;
    }
}

