/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.polyguice.dropwiz;

import com.flipkart.polyguice.core.ConfigurationProvider;
import com.flipkart.polyguice.core.support.Polyguice;
import com.flipkart.polyguice.dropwiz.DropConfigProvider;
import com.flipkart.polyguice.dropwiz.Resource;
import io.dropwizard.Application;
import io.dropwizard.Configuration;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Environment;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolyguiceApp<T extends Configuration>
extends Application<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolyguiceApp.class);
    private List<String> scanPkgNames = new ArrayList<String>();
    private Polyguice polyguice;

    public final PolyguiceApp<T> setPolyguice(Polyguice pg) {
        this.polyguice = pg;
        return this;
    }

    public final PolyguiceApp<T> scanPackage(String name) {
        this.scanPkgNames.add(name);
        return this;
    }

    public final void run(T config, Environment env) throws Exception {
        if (this.polyguice == null) {
            throw new RuntimeException("polyguice not set");
        }
        if (this.polyguice.isPrepared()) {
            throw new RuntimeException("polyguice should not be prepared yet");
        }
        this.preRun(config, env);
        DropConfigProvider dcp = new DropConfigProvider((Configuration)config);
        this.polyguice.registerConfigurationProvider((ConfigurationProvider)dcp);
        this.polyguice.prepare();
        Set<Class<?>> resTypes = this.findResourceTypes();
        LOGGER.debug("found potential resources: {}", resTypes);
        for (Class<?> cls : resTypes) {
            try {
                Object resource = this.createResource(cls, config, env);
                if (resource != null) {
                    LOGGER.debug("resource created: {}", (Object)cls.getName());
                    this.polyguice.getComponentContext().inject(resource);
                    env.jersey().register(resource);
                    continue;
                }
                LOGGER.warn("error creating resource: {}", (Object)cls.getName());
            }
            catch (Exception exep) {
                LOGGER.error(exep.getMessage(), (Throwable)exep);
            }
        }
        List<Class<?>> servletTypes = this.findServletTypes();
        LOGGER.debug("found potential servlets: {}", servletTypes);
        for (Class<?> type : servletTypes) {
            this.registerServlet(type, env);
        }
        env.lifecycle().manage((Managed)new PolyguiceManaged());
        this.postRun(config, env);
    }

    protected final Polyguice getPolyguice() {
        return this.polyguice;
    }

    protected void preRun(T config, Environment env) throws Exception {
    }

    protected void postRun(T config, Environment env) throws Exception {
    }

    private Set<Class<?>> findResourceTypes() {
        Reflections reflections = new Reflections(this.scanPkgNames.toArray());
        return reflections.getTypesAnnotatedWith(Resource.class);
    }

    private List<Class<?>> findServletTypes() {
        Reflections reflections = new Reflections(this.scanPkgNames.toArray());
        Set types = reflections.getTypesAnnotatedWith(WebServlet.class);
        ArrayList result = new ArrayList();
        for (Class type : types) {
            if (!Servlet.class.isAssignableFrom(type)) continue;
            result.add(type);
        }
        return result;
    }

    private Object createResource(Class<?> cls, T config, Environment env) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        int mod;
        Constructor<?> ctor;
        LOGGER.debug("creating object of type {}", cls);
        try {
            ctor = cls.getConstructor(Configuration.class, Environment.class);
            mod = ctor.getModifiers();
            if (Modifier.isPublic(mod) && !Modifier.isAbstract(mod)) {
                LOGGER.debug("using ctor {}", (Object)ctor.toGenericString());
                return ctor.newInstance(config, env);
            }
        }
        catch (NoSuchMethodException exep) {
            // empty catch block
        }
        try {
            ctor = cls.getConstructor(Environment.class, Configuration.class);
            mod = ctor.getModifiers();
            if (Modifier.isPublic(mod) && !Modifier.isAbstract(mod)) {
                LOGGER.debug("using ctor {}", (Object)ctor.toGenericString());
                return ctor.newInstance(env, config);
            }
        }
        catch (NoSuchMethodException exep) {
            // empty catch block
        }
        try {
            ctor = cls.getConstructor(Configuration.class);
            mod = ctor.getModifiers();
            if (Modifier.isPublic(mod) && !Modifier.isAbstract(mod)) {
                LOGGER.debug("using ctor {}", (Object)ctor.toGenericString());
                return ctor.newInstance(config);
            }
        }
        catch (NoSuchMethodException exep) {
            // empty catch block
        }
        try {
            ctor = cls.getConstructor(Environment.class);
            mod = ctor.getModifiers();
            if (Modifier.isPublic(mod) && !Modifier.isAbstract(mod)) {
                LOGGER.debug("using ctor {}", (Object)ctor.toGenericString());
                return ctor.newInstance(env);
            }
        }
        catch (NoSuchMethodException exep) {
            // empty catch block
        }
        try {
            ctor = cls.getConstructor(new Class[0]);
            mod = ctor.getModifiers();
            if (Modifier.isPublic(mod) && !Modifier.isAbstract(mod)) {
                LOGGER.debug("using ctor {}", (Object)ctor.toGenericString());
                return ctor.newInstance(new Object[0]);
            }
        }
        catch (NoSuchMethodException exep) {
            // empty catch block
        }
        return null;
    }

    private void registerServlet(Class<?> type, Environment env) {
        LOGGER.debug("registering servlet: {}", (Object)type.getName());
        WebServlet ann = type.getAnnotation(WebServlet.class);
        String srvName = ann.name();
        if (StringUtils.isBlank((CharSequence)srvName)) {
            LOGGER.error("servlet {}: name could not be blank", (Object)type.getName());
            return;
        }
        String[] paths = ann.urlPatterns();
        if (!(paths != null && paths.length != 0 || (paths = ann.value()) != null && paths.length != 0)) {
            LOGGER.error("url patterns missing for servlet {}", (Object)type.getName());
            return;
        }
        int losu = ann.loadOnStartup();
        Servlet servlet = null;
        try {
            servlet = (Servlet)type.newInstance();
            this.polyguice.getComponentContext().inject((Object)servlet);
        }
        catch (Exception exep) {
            LOGGER.error("error creating servlet {}", (Object)type.getName());
            return;
        }
        ServletRegistration.Dynamic dynamic = env.servlets().addServlet(srvName, servlet);
        dynamic.addMapping(paths);
        dynamic.setLoadOnStartup(losu);
        if (ann.initParams() == null) {
            return;
        }
        for (WebInitParam param : ann.initParams()) {
            String name = param.name();
            String value = param.value();
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name})) continue;
            dynamic.setInitParameter(name, value);
        }
    }

    private class PolyguiceManaged
    implements Managed {
        private PolyguiceManaged() {
        }

        public void start() throws Exception {
        }

        public void stop() throws Exception {
            if (PolyguiceApp.this.polyguice != null) {
                PolyguiceApp.this.polyguice.stop();
            }
        }
    }
}

