/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.polyguice.dropwiz;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.flipkart.polyguice.core.ConfigurationProvider;
import io.dropwizard.Configuration;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropConfigProvider
implements ConfigurationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropConfigProvider.class);
    private Configuration dwConfig;

    public DropConfigProvider(Configuration config) {
        this.dwConfig = config;
    }

    public boolean contains(String path) {
        LOGGER.debug("checking for configuration {}", (Object)path);
        try {
            return this.getValueRecursive(path, this.dwConfig) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Object getValue(String path, Class<?> type) {
        Object value = null;
        try {
            value = this.getValueRecursive(path, this.dwConfig);
        }
        catch (Exception exep) {
            return null;
        }
        if (value == null) {
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return value;
        }
        return null;
    }

    private Object getValueRecursive(String path, Object inst) throws Exception {
        String[] parts = path.split("\\.", 2);
        Object value = this.getValueFromFields(parts[0], inst.getClass(), inst);
        if (value == null) {
            value = this.getValueFromMethods(parts[0], inst.getClass(), inst);
        }
        if (value != null) {
            if (parts.length > 1) {
                return this.getValueRecursive(parts[1], value);
            }
            return value;
        }
        return null;
    }

    private Object getValueFromFields(String path, Class<?> type, Object inst) throws Exception {
        Field[] fields;
        for (Field field : fields = type.getDeclaredFields()) {
            JsonProperty ann = field.getAnnotation(JsonProperty.class);
            if (ann == null) continue;
            String annName = ann.value();
            if (StringUtils.isBlank((CharSequence)annName)) {
                annName = ann.defaultValue();
            }
            if (StringUtils.isBlank((CharSequence)annName)) {
                annName = field.getName();
            }
            if (!StringUtils.equals((CharSequence)path, (CharSequence)annName)) continue;
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            Object value = field.get(inst);
            if (!accessible) {
                field.setAccessible(false);
            }
            return value;
        }
        return null;
    }

    private Object getValueFromMethods(String path, Class<?> type, Object inst) throws Exception {
        Method[] methods;
        for (Method method : methods = type.getDeclaredMethods()) {
            JsonProperty ann = method.getAnnotation(JsonProperty.class);
            if (ann == null) continue;
            String annName = ann.value();
            if (StringUtils.isBlank((CharSequence)annName)) {
                annName = ann.defaultValue();
            }
            if (StringUtils.isBlank((CharSequence)annName)) {
                annName = this.getNameFromMethod(method);
            }
            if (!StringUtils.equals((CharSequence)path, (CharSequence)annName)) continue;
            boolean accessible = method.isAccessible();
            if (!accessible) {
                method.setAccessible(true);
            }
            Object value = method.invoke(inst, new Object[0]);
            if (!accessible) {
                method.setAccessible(false);
            }
            return value;
        }
        return null;
    }

    private String getNameFromMethod(Method method) {
        if (method.getParameterCount() > 0) {
            return null;
        }
        if (method.getReturnType().equals(Void.TYPE)) {
            return null;
        }
        String mthdName = method.getName();
        if (mthdName.startsWith("get")) {
            if (mthdName.length() <= 3) {
                return null;
            }
            if (method.getReturnType().equals(Boolean.class) || method.getReturnType().equals(Boolean.TYPE)) {
                return null;
            }
            StringBuffer buffer = new StringBuffer(StringUtils.removeStart((String)mthdName, (String)"get"));
            buffer.setCharAt(0, Character.toLowerCase(buffer.charAt(0)));
            return buffer.toString();
        }
        if (!mthdName.startsWith("is")) {
            if (mthdName.length() <= 2) {
                return null;
            }
            if (!method.getReturnType().equals(Boolean.class) && !method.getReturnType().equals(Boolean.TYPE)) {
                return null;
            }
            StringBuffer buffer = new StringBuffer(StringUtils.removeStart((String)mthdName, (String)"is"));
            buffer.setCharAt(0, Character.toLowerCase(buffer.charAt(0)));
            return buffer.toString();
        }
        return null;
    }
}

