/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.polyguice.core.support;

import com.flipkart.polyguice.core.External;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExternalsInjector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalsInjector.class);
    private Map<String, Object> externals = new HashMap<String, Object>();

    ExternalsInjector() {
    }

    public void register(String name, Object value) {
        this.externals.put(name, value);
        LOGGER.debug("registered external: {}", (Object)name);
    }

    public void injectComponent(Object target) {
        Method[] methods;
        Field[] fields;
        for (Field field : fields = target.getClass().getDeclaredFields()) {
            if (this.injectField(target, field)) continue;
            throw new RuntimeException("external injection failed on field " + target.getClass().getName() + "#" + field.getName());
        }
        for (Method method : methods = target.getClass().getMethods()) {
            if (this.injectMethod(target, method)) continue;
            throw new RuntimeException("external injection failed on method " + target.getClass().getName() + "#" + method.getName());
        }
    }

    private boolean injectField(Object target, Field field) {
        External ann = field.getAnnotation(External.class);
        if (ann == null) {
            return true;
        }
        LOGGER.debug("field {}#{} has {}", new Object[]{field.getDeclaringClass().getName(), field.getName(), ann.toString()});
        boolean required = ann.required();
        String extName = ann.name();
        if (!(extName != null && extName.trim().length() != 0 || (extName = ann.value()) != null && extName.trim().length() != 0)) {
            LOGGER.warn("InjectExternal on: {} does not have a name", (Object)field.getName());
            return !required;
        }
        Object value = this.externals.get(extName);
        if (value == null) {
            LOGGER.warn("external variable: {} not found", (Object)extName);
            return !required;
        }
        if (!field.getType().isAssignableFrom(value.getClass())) {
            LOGGER.warn("external variable: {} type mismatch", (Object)extName);
            return !required;
        }
        try {
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            field.set(target, value);
            if (!accessible) {
                field.setAccessible(false);
            }
        }
        catch (Exception exep) {
            LOGGER.warn("global variable: {} error injecting", (Object)extName);
            return !required;
        }
        return true;
    }

    private boolean injectMethod(Object target, Method method) {
        External ann = method.getAnnotation(External.class);
        if (ann == null) {
            return true;
        }
        LOGGER.debug("method {}#{} has {}", new Object[]{method.getDeclaringClass().getName(), method.getName(), ann.toString()});
        boolean required = ann.required();
        String extName = ann.name();
        if (!(extName != null && extName.trim().length() != 0 || (extName = ann.value()) != null && extName.trim().length() != 0)) {
            return !required;
        }
        Object value = this.externals.get(extName);
        if (value == null) {
            LOGGER.warn("external variable: {} not found", (Object)extName);
            return !required;
        }
        int mod = method.getModifiers();
        if (Modifier.isAbstract(mod) || !Modifier.isPublic(mod)) {
            LOGGER.warn("method {}#{} must be public and not abstract", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
            return !required;
        }
        if (method.getReturnType() != Void.TYPE) {
            LOGGER.warn("method {}#{} must not have a return type", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
            return !required;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length != 1) {
            LOGGER.warn("method {}#{} must have exactly one parameter", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
            return !required;
        }
        if (!paramTypes[0].isAssignableFrom(value.getClass())) {
            LOGGER.warn("method {}#{} type mismtach with global variable {}", new Object[]{method.getDeclaringClass().getName(), method.getName(), extName});
            return !required;
        }
        try {
            method.invoke(target, value);
        }
        catch (Exception exep) {
            LOGGER.warn("method {}#{} error injecting", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
            return !required;
        }
        return true;
    }
}

