/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.polyguice.core.support;

import com.flipkart.polyguice.core.Configuration;
import com.flipkart.polyguice.core.ConfigurationProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigurationInjector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationInjector.class);
    private List<ConfigurationProvider> configProviders = new ArrayList<ConfigurationProvider>();

    public void register(ConfigurationProvider provider) {
        this.configProviders.add(provider);
        LOGGER.debug("registered configuration provider: {}", (Object)provider.getClass().getName());
    }

    public void injectComponent(Object target) {
        Method[] methods;
        Field[] fields;
        for (Field field : fields = target.getClass().getDeclaredFields()) {
            if (this.injectField(target, field)) continue;
            throw new RuntimeException("preference injection failed on field " + target.getClass().getName() + "#" + field.getName());
        }
        for (Method method : methods = target.getClass().getMethods()) {
            if (this.injectMethod(target, method)) continue;
            throw new RuntimeException("preference injection failed on method " + target.getClass().getName() + "#" + method.getName());
        }
    }

    private boolean injectField(Object target, Field field) {
        Configuration ann = field.getAnnotation(Configuration.class);
        if (ann == null) {
            return true;
        }
        LOGGER.debug("field {}#{} has {}", new Object[]{field.getDeclaringClass().getName(), field.getName(), ann.toString()});
        boolean required = ann.required();
        String key = ann.name();
        if (!(key != null && key.trim().length() != 0 || (key = ann.value()) != null && key.trim().length() != 0)) {
            LOGGER.warn("@Configuration on: {}#{} does not have a name", (Object)field.getDeclaringClass().getName(), (Object)field.getName());
            return !required;
        }
        Object value = this.retrieveConfig(key, field.getType());
        if (value == null) {
            LOGGER.warn("configuration {} not found or not of required type", (Object)key);
            return !required;
        }
        try {
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            field.set(target, value);
            if (!accessible) {
                field.setAccessible(false);
            }
        }
        catch (Exception exep) {
            LOGGER.warn("configuration: {} error injecting on field {}#{}", new Object[]{key, field.getDeclaringClass().getName(), field.getName()});
            return !required;
        }
        return true;
    }

    private boolean injectMethod(Object target, Method method) {
        Configuration ann = method.getAnnotation(Configuration.class);
        if (ann == null) {
            return true;
        }
        LOGGER.debug("method {}#{} has {}", new Object[]{method.getDeclaringClass().getName(), method.getName(), ann.toString()});
        boolean required = ann.required();
        String key = ann.name();
        if (!(key != null && key.trim().length() != 0 || (key = ann.value()) != null && key.trim().length() != 0)) {
            LOGGER.warn("@Configuration on: {}#{} does not have a name", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
            return !required;
        }
        int mod = method.getModifiers();
        if (Modifier.isAbstract(mod) || !Modifier.isPublic(mod)) {
            LOGGER.warn("method {}#{} must be public and not abstract", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
            return !required;
        }
        if (method.getReturnType() != Void.TYPE) {
            LOGGER.warn("method {}#{} must not have a return type", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
            return !required;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length != 1) {
            LOGGER.warn("method {}#{} must have exactly one parameter", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
            return !required;
        }
        Object value = this.retrieveConfig(key, method.getParameterTypes()[0]);
        if (value == null) {
            LOGGER.warn("configuration {} not found or not of required type", (Object)key);
            return !required;
        }
        try {
            method.invoke(target, value);
        }
        catch (Exception exep) {
            LOGGER.warn("configuration: {} error injecting on method {}#{}", new Object[]{key, method.getDeclaringClass().getName(), method.getName()});
            return !required;
        }
        return true;
    }

    private Object retrieveConfig(String name, Class<?> type) {
        for (ConfigurationProvider provider : this.configProviders) {
            Object value;
            if (!provider.contains(name) || (value = provider.getValue(name, type)) == null) continue;
            return value;
        }
        return null;
    }
}

