/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.polyguice.config;

import com.flipkart.polyguice.config.JsonConfiguration;
import com.flipkart.polyguice.config.TimeInterval;
import com.flipkart.polyguice.config.YamlConfiguration;
import com.flipkart.polyguice.core.ConfigurationProvider;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheCommonsConfigProvider
implements ConfigurationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApacheCommonsConfigProvider.class);
    private CompositeConfiguration rootConfig = new CompositeConfiguration();

    public ApacheCommonsConfigProvider location(String loc) {
        try {
            if (loc.toLowerCase(Locale.getDefault()).endsWith(".properties")) {
                PropertiesConfiguration config = new PropertiesConfiguration(new File(loc));
                this.rootConfig.addConfiguration((Configuration)config);
                LOGGER.debug("properties configuration from {}", (Object)loc);
            } else if (loc.toLowerCase(Locale.getDefault()).endsWith(".xml")) {
                XMLConfiguration config = new XMLConfiguration(new File(loc));
                this.rootConfig.addConfiguration((Configuration)config);
                LOGGER.debug("xml configuration from {}", (Object)loc);
            } else if (loc.toLowerCase(Locale.getDefault()).endsWith(".json")) {
                JsonConfiguration config = new JsonConfiguration(new File(loc));
                this.rootConfig.addConfiguration((Configuration)config);
                LOGGER.debug("json configuration from {}", (Object)loc);
            } else if (loc.toLowerCase(Locale.getDefault()).endsWith(".yml")) {
                YamlConfiguration config = new YamlConfiguration(loc);
                this.rootConfig.addConfiguration((Configuration)config);
                LOGGER.debug("yaml configuration from {}", (Object)loc);
            } else if (loc.toLowerCase(Locale.getDefault()).endsWith(".yaml")) {
                YamlConfiguration config = new YamlConfiguration(loc);
                this.rootConfig.addConfiguration((Configuration)config);
                LOGGER.debug("yaml configuration from {}", (Object)loc);
            }
        }
        catch (Exception exep) {
            LOGGER.error("unable to load configuration from " + loc.toString(), (Throwable)exep);
        }
        return this;
    }

    public boolean contains(String path) {
        return this.rootConfig.containsKey(path);
    }

    public Object getValue(String path, Class<?> type) {
        if (!this.rootConfig.containsKey(path)) {
            return null;
        }
        if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            return this.rootConfig.getByte(path, null);
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            return this.rootConfig.getShort(path, null);
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return this.rootConfig.getInteger(path, null);
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return this.rootConfig.getLong(path, null);
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return this.rootConfig.getFloat(path, null);
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return this.rootConfig.getDouble(path, null);
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return this.rootConfig.getBoolean(path, null);
        }
        if (type.equals(String.class)) {
            return this.rootConfig.getString(path);
        }
        if (type.equals(BigInteger.class)) {
            return this.rootConfig.getBigInteger(path);
        }
        if (type.equals(BigDecimal.class)) {
            return this.rootConfig.getBigDecimal(path);
        }
        if (type.equals(Properties.class)) {
            return this.rootConfig.getProperties(path);
        }
        if (type.equals(String[].class)) {
            return this.rootConfig.getStringArray(path);
        }
        if (type.equals(TimeInterval.class)) {
            String interval = this.rootConfig.getString(path);
            if (interval == null) {
                return null;
            }
            return new TimeInterval(interval);
        }
        return null;
    }
}

