/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.polyguice.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonStreamParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.AbstractConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonConfiguration
extends AbstractConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonConfiguration.class);
    private Map<String, Object> configTab;

    public JsonConfiguration(String path) throws IOException {
        FileReader reader = new FileReader(path);
        this.load(reader);
        reader.close();
    }

    public JsonConfiguration(File file) throws IOException {
        FileReader reader = new FileReader(file);
        this.load(reader);
        reader.close();
    }

    public JsonConfiguration(URL url) throws IOException {
        InputStreamReader reader = new InputStreamReader(url.openStream());
        this.load(reader);
        reader.close();
    }

    protected void addPropertyDirect(String s, Object o) {
    }

    public boolean isEmpty() {
        return this.configTab.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.configTab.containsKey(key);
    }

    public Object getProperty(String key) {
        return this.configTab.get(key);
    }

    public Iterator<String> getKeys() {
        return this.configTab.keySet().iterator();
    }

    private void load(Reader in) {
        this.configTab = new HashMap<String, Object>();
        JsonStreamParser parser = new JsonStreamParser(in);
        JsonElement root = null;
        if (parser.hasNext()) {
            root = parser.next();
        }
        if (root != null && root.isJsonObject()) {
            this.flatten(null, root);
        }
        LOGGER.debug("json configuration loaded: {}", this.configTab);
    }

    private void flatten(String prefix, JsonElement element) {
        block4: {
            block2: {
                JsonPrimitive jsonPrim;
                block5: {
                    block3: {
                        if (!element.isJsonPrimitive()) break block2;
                        jsonPrim = element.getAsJsonPrimitive();
                        if (!jsonPrim.isBoolean()) break block3;
                        this.configTab.put(prefix, jsonPrim.getAsBoolean());
                        break block4;
                    }
                    if (!jsonPrim.isNumber()) break block5;
                    this.configTab.put(prefix, jsonPrim.getAsNumber());
                    break block4;
                }
                if (!jsonPrim.isString()) break block4;
                this.configTab.put(prefix, jsonPrim.getAsString());
                break block4;
            }
            if (element.isJsonObject()) {
                JsonObject jsonObj = element.getAsJsonObject();
                for (Map.Entry entry : jsonObj.entrySet()) {
                    String prefix1 = (prefix != null ? prefix + "." : "") + (String)entry.getKey();
                    this.flatten(prefix1, (JsonElement)entry.getValue());
                }
            }
        }
    }
}

