/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.impl;

import com.flipkart.phantom.task.impl.TaskHandler;
import com.flipkart.phantom.task.spi.Decoder;
import com.flipkart.phantom.task.spi.TaskContext;
import com.flipkart.phantom.task.spi.TaskRequestWrapper;
import com.flipkart.phantom.task.spi.TaskResult;
import com.netflix.hystrix.HystrixCommandProperties;
import java.util.HashMap;
import java.util.Map;

public abstract class HystrixTaskHandler
extends TaskHandler {
    public static final int DEFAULT_EXECUTOR_TIMEOUT = 1000;
    private Map<String, Integer> concurrentPoolSizeParams = new HashMap<String, Integer>();
    private Map<String, Integer> commandPoolSizeParams = new HashMap<String, Integer>();
    protected Map<String, Integer> executorTimeouts = new HashMap<String, Integer>();

    public abstract <T, S> TaskResult<T> getFallBack(TaskContext var1, String var2, Map<String, Object> var3, S var4);

    public <T, S> TaskResult<T> getFallBack(TaskContext taskContext, String command, TaskRequestWrapper<S> taskRequestWrapper, Decoder<T> decoder) throws RuntimeException {
        return null;
    }

    public <T> void releaseResources(TaskResult<T> taskResult) {
    }

    public HystrixCommandProperties.ExecutionIsolationStrategy getIsolationStrategy() {
        return HystrixCommandProperties.ExecutionIsolationStrategy.THREAD;
    }

    public int getExecutorTimeout(String commandName) {
        Integer timeout = this.getExecutorTimeouts().get(commandName);
        return timeout != null ? timeout : 1000;
    }

    public Map<String, Integer> getCommandPoolSizeParams() {
        return this.commandPoolSizeParams;
    }

    public void setCommandPoolSizeParams(Map<String, Integer> commandPoolSizeParams) {
        this.commandPoolSizeParams = commandPoolSizeParams;
    }

    public Map<String, Integer> getConcurrentPoolSizeParams() {
        return this.concurrentPoolSizeParams;
    }

    public void setConcurrentPoolSizeParams(Map<String, Integer> concurrentPoolSizeParams) {
        this.concurrentPoolSizeParams = concurrentPoolSizeParams;
    }

    public Map<String, Integer> getExecutorTimeouts() {
        return this.executorTimeouts;
    }

    public void setExecutorTimeouts(Map<String, Integer> executorTimeouts) {
        this.executorTimeouts = executorTimeouts;
    }
}

