/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.event.consumer;

import com.flipkart.phantom.event.ServiceProxyEvent;
import com.flipkart.phantom.event.consumer.RequestLogger;
import com.github.kristofa.brave.zipkin.ZipkinSpanCollector;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.trpr.platform.core.impl.event.AbstractEndpointEventConsumerImpl;
import org.trpr.platform.core.spi.event.EndpointEventConsumer;
import org.trpr.platform.model.event.PlatformEvent;

public class PushToZipkinEventConsumer
extends AbstractEndpointEventConsumerImpl
implements InitializingBean {
    private ZipkinSpanCollector zipkinSpanCollector;
    private RequestLogger requestLogger;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)((Object)this.requestLogger), (String)"The 'requestLogger' may not be null");
        String[] stringArray = this.getSubscriptions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String subscription = stringArray[n2];
            this.requestLogger.addSubscriptionAndConsumer(subscription, (EndpointEventConsumer)this);
            ++n2;
        }
    }

    protected void handlePlatformEvent(PlatformEvent platformEvent) {
        if (platformEvent instanceof ServiceProxyEvent) {
            this.zipkinSpanCollector.collect(((ServiceProxyEvent)platformEvent).getSpan());
        }
    }

    public void setZipkinSpanCollector(ZipkinSpanCollector zipkinSpanCollector) {
        this.zipkinSpanCollector = zipkinSpanCollector;
    }

    public void setRequestLogger(RequestLogger requestLogger) {
        this.requestLogger = requestLogger;
    }
}

