/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.impl;

import com.flipkart.phantom.task.impl.TaskRequestWrapper;
import com.flipkart.phantom.task.impl.TaskResult;
import com.flipkart.phantom.task.spi.AbstractHandler;
import com.flipkart.phantom.task.spi.Decoder;
import com.flipkart.phantom.task.spi.TaskContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.util.StringUtils;
import org.trpr.platform.core.PlatformException;

public abstract class TaskHandler
extends AbstractHandler
implements DisposableBean {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = -1;
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskHandler.class);
    public static String PARAM_COMMAND_NAME = "commandName";
    protected List<Map<String, String>> initializationCommands = new LinkedList<Map<String, String>>();

    @Override
    public String getType() {
        return "TaskHandler";
    }

    @Override
    public String getHost() {
        return DEFAULT_HOST;
    }

    @Override
    public int getPort() {
        return -1;
    }

    @Override
    public String getDetails() {
        String[] commands = this.getCommands();
        if (commands != null && commands.length > 0) {
            return "Commands: " + StringUtils.collectionToDelimitedString(Arrays.asList(commands), (String)", ");
        }
        return "No commands registered";
    }

    @Override
    public void init(TaskContext taskContext) throws Exception {
        if (this.initializationCommands == null || this.initializationCommands.size() == 0) {
            LOGGER.info("No initialization commands specified for the TaskHandler: " + this.getName());
        } else {
            for (Map<String, String> initParam : this.initializationCommands) {
                String commandName = initParam.get(PARAM_COMMAND_NAME);
                if (commandName == null) {
                    LOGGER.error("Fatal error. commandName not specified in initializationCommands for TaskHandler: " + this.getName());
                    throw new UnsupportedOperationException("Fatal error. commandName not specified in initializationCommands of TaskHandler: " + this.getName());
                }
                TaskResult<byte[]> result = this.execute(taskContext, commandName, new HashMap<String, String>(initParam), null);
                if (result == null || result.isSuccess()) continue;
                throw new PlatformException("Initialization command: " + commandName + " failed for TaskHandler: " + this.getName() + " The params were: " + initParam);
            }
        }
    }

    public abstract TaskResult<byte[]> execute(TaskContext var1, String var2, Map<String, String> var3, byte[] var4) throws RuntimeException;

    public <T> TaskResult<T> execute(TaskContext taskContext, String command, TaskRequestWrapper taskRequestWrapper, Decoder<T> decoder) throws RuntimeException {
        throw new UnsupportedOperationException("Not Supported. It has to be implemented by sub-classes");
    }

    public abstract String[] getCommands();

    public void destroy() throws Exception {
        this.shutdown(null);
    }

    public List<Map<String, String>> getInitializationCommands() {
        return this.initializationCommands;
    }

    public void setInitializationCommands(List<Map<String, String>> initializationCommands) {
        this.initializationCommands = initializationCommands;
    }
}

