/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.spi.registry;

import com.flipkart.phantom.task.spi.AbstractHandler;
import com.flipkart.phantom.task.spi.TaskContext;
import com.flipkart.phantom.task.spi.registry.HandlerConfigInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import org.trpr.platform.core.PlatformException;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public abstract class AbstractHandlerRegistry<T extends AbstractHandler> {
    private static final Logger LOGGER = LogFactory.getLogger(AbstractHandlerRegistry.class);
    private static final int DEFAULT_HANDLER_INIT_CONCURRENCY = 5;
    private int handlerInitConcurrency = 5;
    protected Map<String, T> handlers = new HashMap<String, T>();

    public InitedHandlerInfo<T>[] init(List<HandlerConfigInfo> handlerConfigInfoList, TaskContext taskContext) throws Exception {
        LinkedList<InitedHandlerInfo<InitedHandlerInfo>> initedHandlerInfos = new LinkedList<InitedHandlerInfo<InitedHandlerInfo>>();
        LinkedList<HandlerConfigInfo> tempHandlerConfigInfoList = new LinkedList<HandlerConfigInfo>();
        tempHandlerConfigInfoList.addAll(handlerConfigInfoList);
        Collections.sort(tempHandlerConfigInfoList, new Comparator<HandlerConfigInfo>(){

            @Override
            public int compare(HandlerConfigInfo o1, HandlerConfigInfo o2) {
                return o1.getLoadOrder() - o2.getLoadOrder();
            }
        });
        for (int i = 0; i < tempHandlerConfigInfoList.size(); ++i) {
            HandlerConfigInfo handlerConfigInfo = (HandlerConfigInfo)tempHandlerConfigInfoList.get(i);
            if (handlerConfigInfo.getLoadOrder() != 0) {
                this.initHandlers(initedHandlerInfos, taskContext, this.getHandlerInitConcurrency(), tempHandlerConfigInfoList.subList(i, tempHandlerConfigInfoList.size()).toArray(new HandlerConfigInfo[0]));
                break;
            }
            this.initHandlers(initedHandlerInfos, taskContext, 1, handlerConfigInfo);
        }
        return initedHandlerInfos.toArray(new InitedHandlerInfo[0]);
    }

    public void reinitHandler(String name, TaskContext taskContext) throws Exception {
        AbstractHandler handler = (AbstractHandler)this.handlers.get(name);
        if (handler != null) {
            try {
                handler.deactivate();
                handler.shutdown(taskContext);
                handler.init(taskContext);
                handler.activate();
            }
            catch (Exception e) {
                LOGGER.error("Error initializing " + this.getHandlerType().getName() + " : {}. Error is: " + e.getMessage(), (Object)handler.getName(), (Object)e);
                throw new PlatformException("Error reinitialising " + this.getHandlerType().getName() + " : " + handler.getName(), (Throwable)e);
            }
        }
    }

    public void shutdown(TaskContext taskContext) throws Exception {
        for (String name : this.handlers.keySet()) {
            LOGGER.info("Shutting down {}: " + name, (Object)this.getHandlerType().getName());
            try {
                ((AbstractHandler)this.handlers.get(name)).shutdown(taskContext);
                ((AbstractHandler)this.handlers.get(name)).deactivate();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to shutdown {}: " + name, (Object)this.getHandlerType().getName(), (Object)e);
            }
        }
    }

    public List<T> getHandlers() {
        return new ArrayList<T>(this.handlers.values());
    }

    public T getHandler(String name) {
        return (T)((AbstractHandler)this.handlers.get(name));
    }

    public void unregisterTaskHandler(T handler) {
        this.handlers.remove(((AbstractHandler)handler).getName());
        this.postUnregisterHandler(handler);
    }

    protected abstract Class<T> getHandlerType();

    protected void postInitHandler(T handler) {
    }

    protected void postUnregisterHandler(T handler) {
    }

    private void initHandlers(final List<InitedHandlerInfo<T>> initedHandlerInfos, final TaskContext taskContext, int concurrency, HandlerConfigInfo ... configInfos) {
        ExecutorService pool = Executors.newFixedThreadPool(concurrency, new ThreadFactory(){
            int nameSuffix = -1;

            @Override
            public Thread newThread(Runnable r) {
                ++this.nameSuffix;
                return new Thread(r, "Handler-Init-Thread-" + this.nameSuffix);
            }
        });
        LinkedList handlerInitTasks = new LinkedList();
        for (final HandlerConfigInfo handlerConfigInfo : configInfos) {
            String[] handlerBeanIds;
            for (String taskHandlerBeanId : handlerBeanIds = handlerConfigInfo.getProxyHandlerContext().getBeanNamesForType(this.getHandlerType())) {
                final AbstractHandler handler = (AbstractHandler)handlerConfigInfo.getProxyHandlerContext().getBean(taskHandlerBeanId);
                FutureTask handlerInitTask = new FutureTask(new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        try {
                            if (!handler.isActive()) {
                                LOGGER.info("Initializing {} : " + handler.getName(), (Object)AbstractHandlerRegistry.this.getHandlerType().getName());
                                handler.init(taskContext);
                                AbstractHandlerRegistry.this.postInitHandler(handler);
                                handler.activate();
                                initedHandlerInfos.add(new InitedHandlerInfo<AbstractHandler>(handler, handlerConfigInfo));
                                AbstractHandlerRegistry.this.handlers.put(handler.getName(), handler);
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("Error initializing " + AbstractHandlerRegistry.this.getHandlerType().getName() + " : {}. Error is: " + e.getMessage(), (Object)handler.getName(), (Object)e);
                        }
                        return handler;
                    }
                });
                handlerInitTasks.add(handlerInitTask);
                pool.execute(handlerInitTask);
            }
        }
        for (FutureTask futureTask : handlerInitTasks) {
            AbstractHandler initedHandler = null;
            try {
                initedHandler = (AbstractHandler)futureTask.get();
            }
            catch (Exception e) {
                LOGGER.error("Error initializing handlers of type : " + this.getHandlerType().getName() + ".Error is: " + e.getMessage(), (Throwable)e);
                pool.shutdownNow();
                throw new PlatformException("Error initializing handlers of type : " + this.getHandlerType().getName() + ".Error is: " + e.getMessage(), (Throwable)e);
            }
            if (initedHandler.isActive()) continue;
            if (initedHandler.getInitOutcomeStatus() == 999999) {
                pool.shutdownNow();
                throw new PlatformException("Error initializing vetoing handler " + this.getHandlerType().getName() + " : " + initedHandler.getName());
            }
            LOGGER.warn("Continuing after init failed for non-vetoing handler " + this.getHandlerType().getName() + " : " + initedHandler.getName());
        }
        pool.shutdown();
    }

    public int getHandlerInitConcurrency() {
        return this.handlerInitConcurrency;
    }

    public void setHandlerInitConcurrency(int handlerInitConcurrency) {
        this.handlerInitConcurrency = handlerInitConcurrency;
    }

    public static final class InitedHandlerInfo<T extends AbstractHandler> {
        private T initedHandler;
        private HandlerConfigInfo handlerConfigInfo;

        public InitedHandlerInfo(T initedHandler, HandlerConfigInfo handlerConfigInfo) {
            this.initedHandler = initedHandler;
            this.handlerConfigInfo = handlerConfigInfo;
        }

        public T getInitedHandler() {
            return this.initedHandler;
        }

        public HandlerConfigInfo getHandlerConfigInfo() {
            return this.handlerConfigInfo;
        }
    }
}

