/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.impl;

import com.flipkart.phantom.task.impl.HystrixTaskHandler;
import com.flipkart.phantom.task.impl.RequestCacheableHystrixTaskHandler;
import com.flipkart.phantom.task.impl.RequestCacheableTaskHandlerExecutor;
import com.flipkart.phantom.task.impl.TaskHandler;
import com.flipkart.phantom.task.impl.TaskHandlerExecutor;
import com.flipkart.phantom.task.impl.TaskRequestWrapper;
import com.flipkart.phantom.task.impl.TaskResult;
import com.flipkart.phantom.task.impl.registry.TaskHandlerRegistry;
import com.flipkart.phantom.task.spi.Decoder;
import com.flipkart.phantom.task.spi.Executor;
import com.flipkart.phantom.task.spi.RequestWrapper;
import com.flipkart.phantom.task.spi.TaskContext;
import com.flipkart.phantom.task.spi.registry.AbstractHandlerRegistry;
import com.flipkart.phantom.task.spi.repository.ExecutorRepository;
import com.netflix.hystrix.HystrixCommandProperties;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskHandlerExecutorRepository
implements ExecutorRepository<TaskResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskHandlerExecutorRepository.class);
    public static final String ONLY_ALPHANUMERIC_REGEX = "[^\\dA-Za-z_]";
    public static final String WHITESPACE_REGEX = "\\s+";
    private static final int DEFAULT_THREAD_POOL_SIZE = 10;
    private TaskHandlerRegistry registry;
    private TaskContext taskContext;

    @Override
    public Executor<TaskResult> getExecutor(String commandName, String proxyName, RequestWrapper requestWrapper) {
        TaskHandler taskHandler;
        String refinedCommandName = commandName.replaceAll(ONLY_ALPHANUMERIC_REGEX, "").replaceAll(WHITESPACE_REGEX, "");
        String refinedProxyName = proxyName.replaceAll(ONLY_ALPHANUMERIC_REGEX, "").replaceAll(WHITESPACE_REGEX, "");
        if (!commandName.equals(refinedCommandName)) {
            LOGGER.debug("Command names are not allowed to have Special characters/ whitespaces. Replacing: " + commandName + " with " + refinedCommandName);
        }
        if (!proxyName.equals(refinedProxyName)) {
            LOGGER.debug("Thread pool names are not allowed to have Special characters/ whitespaces. Replacing: " + proxyName + " with " + refinedProxyName);
        }
        if (proxyName.isEmpty()) {
            proxyName = commandName;
            LOGGER.debug("null/empty threadPoolName passed. defaulting to commandName: " + commandName);
        }
        if ((taskHandler = this.getTaskHandlerRegistry().getTaskHandlerByCommand(commandName)) != null) {
            if (!taskHandler.isActive()) {
                LOGGER.error("TaskHandler: " + taskHandler.getName() + " is not yet active. Command: " + commandName + " will not be processed");
                return null;
            }
            if (taskHandler instanceof HystrixTaskHandler) {
                HystrixTaskHandler hystrixTaskHandler = (HystrixTaskHandler)taskHandler;
                LOGGER.debug("Isolation strategy: " + hystrixTaskHandler.getIsolationStrategy() + " for " + hystrixTaskHandler);
                int maxConcurrentSize = 10;
                if (this.getTaskHandlerRegistry().getPoolSize(proxyName) != null) {
                    LOGGER.debug("Found a predefined pool size for " + proxyName + ". Not using default value of " + 10);
                    maxConcurrentSize = this.getTaskHandlerRegistry().getPoolSize(proxyName);
                }
                if (hystrixTaskHandler.getIsolationStrategy() == HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE) {
                    return this.getTaskHandlerExecutorWithSemaphoreIsolation((TaskRequestWrapper)requestWrapper, refinedCommandName, taskHandler, maxConcurrentSize);
                }
                return this.getTaskHandlerExecutor((TaskRequestWrapper)requestWrapper, refinedCommandName, refinedProxyName, maxConcurrentSize, hystrixTaskHandler.getExecutorTimeout(commandName), taskHandler);
            }
            return this.getTaskHandlerExecutor((TaskRequestWrapper)requestWrapper, refinedCommandName, refinedProxyName, 1000, 10, taskHandler);
        }
        throw new UnsupportedOperationException("Invoked unsupported command : " + commandName);
    }

    public Executor<TaskResult> getExecutor(String commandName, String proxyName, RequestWrapper requestWrapper, Decoder decoder) {
        TaskHandler taskHandler;
        String refinedCommandName = commandName.replaceAll(ONLY_ALPHANUMERIC_REGEX, "").replaceAll(WHITESPACE_REGEX, "");
        String refinedProxyName = proxyName.replaceAll(ONLY_ALPHANUMERIC_REGEX, "").replaceAll(WHITESPACE_REGEX, "");
        if (!commandName.equals(refinedCommandName)) {
            LOGGER.debug("Command names are not allowed to have Special characters/ whitespaces. Replacing: " + commandName + " with " + refinedCommandName);
        }
        if (!proxyName.equals(refinedProxyName)) {
            LOGGER.debug("Thread pool names are not allowed to have Special characters/ whitespaces. Replacing: " + proxyName + " with " + refinedProxyName);
        }
        if (proxyName.isEmpty()) {
            proxyName = commandName;
            LOGGER.debug("null/empty threadPoolName passed. defaulting to commandName: " + commandName);
        }
        if ((taskHandler = this.getTaskHandlerRegistry().getTaskHandlerByCommand(commandName)) != null) {
            if (!taskHandler.isActive()) {
                LOGGER.error("TaskHandler: " + taskHandler.getName() + " is not yet active. Command: " + commandName + " will not be processed");
                return null;
            }
            if (taskHandler instanceof HystrixTaskHandler) {
                HystrixTaskHandler hystrixTaskHandler = (HystrixTaskHandler)taskHandler;
                LOGGER.debug("Isolation strategy: " + hystrixTaskHandler.getIsolationStrategy() + " for " + hystrixTaskHandler);
                int maxConcurrentSize = 10;
                if (this.getTaskHandlerRegistry().getPoolSize(proxyName) != null) {
                    LOGGER.debug("Found a predefined pool size for " + proxyName + ". Not using default value of " + 10);
                    maxConcurrentSize = this.getTaskHandlerRegistry().getPoolSize(proxyName);
                }
                if (hystrixTaskHandler.getIsolationStrategy() == HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE) {
                    return this.getTaskHandlerExecutorWithSemaphoreIsolationAndDecoder((TaskRequestWrapper)requestWrapper, refinedCommandName, taskHandler, maxConcurrentSize, decoder);
                }
                return this.getTaskHandlerExecutorWithDecoder((TaskRequestWrapper)requestWrapper, refinedCommandName, refinedProxyName, maxConcurrentSize, hystrixTaskHandler.getExecutorTimeout(commandName), taskHandler, decoder);
            }
            return this.getTaskHandlerExecutorWithDecoder((TaskRequestWrapper)requestWrapper, refinedCommandName, refinedProxyName, 1000, 10, taskHandler, decoder);
        }
        throw new UnsupportedOperationException("Invoked unsupported command : " + commandName);
    }

    public Executor<TaskResult> getExecutor(String commandName, RequestWrapper requestWrapper) {
        return this.getExecutor(commandName, commandName, requestWrapper);
    }

    public Future<TaskResult> executeAsyncCommand(String commandName, String proxyName, RequestWrapper requestWrapper) throws UnsupportedOperationException {
        TaskHandlerExecutor command = (TaskHandlerExecutor)this.getExecutor(commandName, proxyName, requestWrapper);
        if (command == null) {
            throw new UnsupportedOperationException("Invoked unsupported command : " + commandName);
        }
        return command.queue();
    }

    public TaskResult executeCommand(String commandName, String proxyName, RequestWrapper requestWrapper) throws UnsupportedOperationException {
        TaskHandlerExecutor command = (TaskHandlerExecutor)this.getExecutor(commandName, proxyName, requestWrapper);
        if (command == null) {
            throw new UnsupportedOperationException("Invoked unsupported command : " + commandName);
        }
        try {
            return (TaskResult)command.execute();
        }
        catch (Exception e) {
            throw new RuntimeException("Error in processing command " + commandName + ": " + e.getMessage(), e);
        }
    }

    public TaskResult executeCommand(String commandName, RequestWrapper requestWrapper) throws UnsupportedOperationException {
        return this.executeCommand(commandName, commandName, requestWrapper);
    }

    public <T> TaskResult<T> executeCommand(String commandName, RequestWrapper requestWrapper, Decoder<T> decoder) throws UnsupportedOperationException {
        TaskHandlerExecutor command = (TaskHandlerExecutor)this.getExecutor(commandName, commandName, requestWrapper, decoder);
        if (command == null) {
            throw new UnsupportedOperationException("Invoked unsupported command : " + commandName);
        }
        try {
            return (TaskResult)command.execute();
        }
        catch (Exception e) {
            throw new RuntimeException("Error in processing command " + commandName + ": " + e.getMessage(), e);
        }
    }

    public Future<TaskResult> executeAsyncCommand(String commandName, RequestWrapper requestWrapper, Decoder decoder) throws UnsupportedOperationException {
        TaskHandlerExecutor command = (TaskHandlerExecutor)this.getExecutor(commandName, commandName, requestWrapper, decoder);
        if (command == null) {
            throw new UnsupportedOperationException("Invoked unsupported command : " + commandName);
        }
        return command.queue();
    }

    public Future<TaskResult> executeAsyncCommand(String commandName, RequestWrapper requestWrapper) throws UnsupportedOperationException {
        return this.executeAsyncCommand(commandName, commandName, requestWrapper);
    }

    @Override
    public AbstractHandlerRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void setRegistry(AbstractHandlerRegistry taskHandlerRegistry) {
        this.registry = (TaskHandlerRegistry)taskHandlerRegistry;
    }

    @Override
    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    @Override
    public void setTaskContext(TaskContext taskContext) {
        this.taskContext = taskContext;
    }

    public TaskHandlerRegistry getTaskHandlerRegistry() {
        AbstractHandlerRegistry registry = this.getRegistry();
        if (registry instanceof TaskHandlerRegistry) {
            return (TaskHandlerRegistry)registry;
        }
        return new TaskHandlerRegistry();
    }

    private Executor<TaskResult> getTaskHandlerExecutorWithSemaphoreIsolation(TaskRequestWrapper requestWrapper, String refinedCommandName, TaskHandler taskHandler, int maxConcurrentSize) {
        if (taskHandler instanceof RequestCacheableHystrixTaskHandler) {
            return new RequestCacheableTaskHandlerExecutor((RequestCacheableHystrixTaskHandler)taskHandler, this.getTaskContext(), refinedCommandName, requestWrapper, maxConcurrentSize);
        }
        return new TaskHandlerExecutor(taskHandler, this.getTaskContext(), refinedCommandName, requestWrapper, maxConcurrentSize);
    }

    private Executor<TaskResult> getTaskHandlerExecutor(TaskRequestWrapper requestWrapper, String refinedCommandName, String refinedProxyName, int maxConcurrentSize, int executorTimeOut, TaskHandler taskHandler) {
        if (taskHandler instanceof RequestCacheableHystrixTaskHandler) {
            return new RequestCacheableTaskHandlerExecutor((RequestCacheableHystrixTaskHandler)taskHandler, this.getTaskContext(), refinedCommandName, executorTimeOut, refinedProxyName, maxConcurrentSize, requestWrapper);
        }
        return new TaskHandlerExecutor(taskHandler, this.getTaskContext(), refinedCommandName, executorTimeOut, refinedProxyName, maxConcurrentSize, requestWrapper);
    }

    private Executor<TaskResult> getTaskHandlerExecutorWithSemaphoreIsolationAndDecoder(TaskRequestWrapper requestWrapper, String refinedCommandName, TaskHandler taskHandler, int maxConcurrentSize, Decoder decoder) {
        if (taskHandler instanceof RequestCacheableHystrixTaskHandler) {
            return new RequestCacheableTaskHandlerExecutor((RequestCacheableHystrixTaskHandler)taskHandler, this.getTaskContext(), refinedCommandName, requestWrapper, maxConcurrentSize, decoder);
        }
        return new TaskHandlerExecutor(taskHandler, this.getTaskContext(), refinedCommandName, requestWrapper, maxConcurrentSize, decoder);
    }

    private Executor<TaskResult> getTaskHandlerExecutorWithDecoder(TaskRequestWrapper requestWrapper, String refinedCommandName, String refinedProxyName, int maxConcurrentSize, int executorTimeOut, TaskHandler taskHandler, Decoder decoder) {
        if (taskHandler instanceof RequestCacheableHystrixTaskHandler) {
            return new RequestCacheableTaskHandlerExecutor((RequestCacheableHystrixTaskHandler)taskHandler, this.getTaskContext(), refinedCommandName, executorTimeOut, refinedProxyName, maxConcurrentSize, requestWrapper, decoder);
        }
        return new TaskHandlerExecutor(taskHandler, this.getTaskContext(), refinedCommandName, executorTimeOut, refinedProxyName, maxConcurrentSize, requestWrapper, decoder);
    }
}

