/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.impl;

import com.flipkart.phantom.event.ServiceProxyEvent;
import com.flipkart.phantom.task.impl.HystrixTaskHandler;
import com.flipkart.phantom.task.impl.TaskHandler;
import com.flipkart.phantom.task.impl.TaskRequestWrapper;
import com.flipkart.phantom.task.impl.TaskResult;
import com.flipkart.phantom.task.spi.Decoder;
import com.flipkart.phantom.task.spi.Executor;
import com.flipkart.phantom.task.spi.TaskContext;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import java.util.Map;

public class TaskHandlerExecutor
extends HystrixCommand<TaskResult>
implements Executor<TaskResult> {
    public static final String NO_RESULT = "The command returned no result";
    public static final String ASYNC_QUEUED = "The command dispatched for async execution";
    public static final String DEFAULT_HYSTRIX_GROUP = "DEFAULT_GROUP";
    public static final String DEFAULT_HYSTRIX_THREAD_POOL = "DEFAULT_THREAD_POOL";
    public static final int DEFAULT_HYSTRIX_THREAD_POOL_SIZE = 10;
    protected TaskHandler taskHandler;
    protected TaskContext taskContext;
    protected String command;
    protected Map<String, String> params;
    protected byte[] data;
    protected TaskRequestWrapper taskRequestWrapper;
    protected Decoder decoder;
    protected ServiceProxyEvent.Builder eventBuilder;
    private static final String COMMAND_HANDLER = "COMMAND_HANDLER";

    protected TaskHandlerExecutor(TaskHandler taskHandler, TaskContext taskContext, String commandName, int timeout, String threadPoolName, int threadPoolSize, TaskRequestWrapper taskRequestWrapper) {
        super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)taskHandler.getName())).andCommandKey(HystrixCommandKey.Factory.asKey((String)commandName)).andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)threadPoolName)).andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter().withCoreSize(threadPoolSize)).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationThreadTimeoutInMilliseconds(timeout)));
        this.taskHandler = taskHandler;
        this.taskContext = taskContext;
        this.command = commandName;
        this.data = taskRequestWrapper.getData();
        this.params = taskRequestWrapper.getParams();
        this.taskRequestWrapper = taskRequestWrapper;
        this.eventBuilder = new ServiceProxyEvent.Builder(commandName, COMMAND_HANDLER);
    }

    protected TaskHandlerExecutor(TaskHandler taskHandler, TaskContext taskContext, String commandName, int timeout, String threadPoolName, int threadPoolSize, TaskRequestWrapper taskRequestWrapper, Decoder decoder) {
        super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)taskHandler.getName())).andCommandKey(HystrixCommandKey.Factory.asKey((String)commandName)).andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)threadPoolName)).andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter().withCoreSize(threadPoolSize)).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationThreadTimeoutInMilliseconds(timeout)));
        this.taskHandler = taskHandler;
        this.taskContext = taskContext;
        this.command = commandName;
        this.data = taskRequestWrapper.getData();
        this.params = taskRequestWrapper.getParams();
        this.taskRequestWrapper = taskRequestWrapper;
        this.eventBuilder = new ServiceProxyEvent.Builder(commandName, COMMAND_HANDLER);
        this.decoder = decoder;
    }

    protected TaskHandlerExecutor(TaskHandler taskHandler, TaskContext taskContext, String commandName, TaskRequestWrapper taskRequestWrapper, int concurrentRequestSize) {
        super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)taskHandler.getName())).andCommandKey(HystrixCommandKey.Factory.asKey((String)commandName)).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE).withExecutionIsolationSemaphoreMaxConcurrentRequests(concurrentRequestSize)));
        this.taskHandler = taskHandler;
        this.taskContext = taskContext;
        this.command = commandName;
        this.data = taskRequestWrapper.getData();
        this.params = taskRequestWrapper.getParams();
        this.taskRequestWrapper = taskRequestWrapper;
        this.eventBuilder = new ServiceProxyEvent.Builder(commandName, COMMAND_HANDLER);
    }

    protected TaskHandlerExecutor(TaskHandler taskHandler, TaskContext taskContext, String commandName, TaskRequestWrapper taskRequestWrapper, int concurrentRequestSize, Decoder decoder) {
        super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)taskHandler.getName())).andCommandKey(HystrixCommandKey.Factory.asKey((String)commandName)).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE).withExecutionIsolationSemaphoreMaxConcurrentRequests(concurrentRequestSize)));
        this.taskHandler = taskHandler;
        this.taskContext = taskContext;
        this.command = commandName;
        this.data = taskRequestWrapper.getData();
        this.params = taskRequestWrapper.getParams();
        this.taskRequestWrapper = taskRequestWrapper;
        this.decoder = decoder;
        this.eventBuilder = new ServiceProxyEvent.Builder(commandName, COMMAND_HANDLER);
    }

    public TaskHandlerExecutor(TaskHandler taskHandler, TaskContext taskContext, String commandName, int executorTimeout, TaskRequestWrapper taskRequestWrapper) {
        this(taskHandler, taskContext, commandName, executorTimeout, DEFAULT_HYSTRIX_THREAD_POOL, 10, taskRequestWrapper);
    }

    public TaskHandlerExecutor(TaskHandler taskHandler, TaskContext taskContext, String commandName, int executorTimeout, TaskRequestWrapper taskRequestWrapper, Decoder decoder) {
        this(taskHandler, taskContext, commandName, executorTimeout, DEFAULT_HYSTRIX_THREAD_POOL, 10, taskRequestWrapper, decoder);
    }

    protected TaskResult run() throws Exception {
        this.eventBuilder.withRequestExecutionStartTime(System.currentTimeMillis());
        if (this.decoder == null) {
            TaskResult<byte[]> result = this.taskHandler.execute(this.taskContext, this.command, this.params, this.data);
            if (result == null) {
                return new TaskResult(true, NO_RESULT);
            }
            if (!result.isSuccess()) {
                throw new RuntimeException("Command returned FALSE: " + result.getMessage());
            }
            return result;
        }
        TaskResult result = this.taskHandler.execute(this.taskContext, this.command, this.taskRequestWrapper, this.decoder);
        if (result == null) {
            return new TaskResult<Object>(true, NO_RESULT, null);
        }
        if (!result.isSuccess()) {
            throw new RuntimeException("Command returned FALSE: " + result.getMessage());
        }
        return result;
    }

    protected TaskResult getFallback() {
        if (this.taskHandler instanceof HystrixTaskHandler) {
            HystrixTaskHandler hystrixTaskHandler = (HystrixTaskHandler)this.taskHandler;
            return hystrixTaskHandler.getFallBack(this.taskContext, this.command, this.params, this.data);
        }
        return null;
    }

    public int getCallInvocationType() {
        Integer callInvocationType;
        if (this.taskHandler.getCallInvocationTypePerCommand() != null && (callInvocationType = this.taskHandler.getCallInvocationTypePerCommand().get(this.command)) != null) {
            return callInvocationType;
        }
        return this.taskHandler.getCallInvocationType();
    }

    @Override
    public ServiceProxyEvent.Builder getEventBuilder() {
        return this.eventBuilder;
    }
}

