/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.impl;

import com.flipkart.phantom.task.impl.TaskHandler;
import com.flipkart.phantom.task.impl.TaskResult;
import com.flipkart.phantom.task.spi.TaskContext;
import com.netflix.hystrix.HystrixCommandProperties;
import java.util.HashMap;
import java.util.Map;

public abstract class HystrixTaskHandler
extends TaskHandler {
    public static final int DEFAULT_EXECUTOR_TIMEOUT = 10000;
    private Map<String, Integer> threadPoolSizeParams = new HashMap<String, Integer>();
    private Map<String, Integer> commandPoolSizeParams = new HashMap<String, Integer>();
    protected Map<String, Integer> executorTimeouts = new HashMap<String, Integer>();

    public abstract TaskResult getFallBack(TaskContext var1, String var2, Map<String, String> var3, byte[] var4);

    public HystrixCommandProperties.ExecutionIsolationStrategy getIsolationStrategy() {
        return HystrixCommandProperties.ExecutionIsolationStrategy.THREAD;
    }

    public int getExecutorTimeout(String commandName) {
        Integer timeout = this.getExecutorTimeouts().get(commandName);
        return timeout != null ? timeout : 10000;
    }

    public Map<String, Integer> getCommandPoolSizeParams() {
        return this.commandPoolSizeParams;
    }

    public void setCommandPoolSizeParams(Map<String, Integer> commandPoolSizeParams) {
        this.commandPoolSizeParams = commandPoolSizeParams;
    }

    public Map<String, Integer> getThreadPoolSizeParams() {
        return this.threadPoolSizeParams;
    }

    public void setThreadPoolSizeParams(Map<String, Integer> threadPoolSizeParams) {
        this.threadPoolSizeParams = threadPoolSizeParams;
    }

    public Map<String, Integer> getExecutorTimeouts() {
        return this.executorTimeouts;
    }

    public void setExecutorTimeouts(Map<String, Integer> executorTimeouts) {
        this.executorTimeouts = executorTimeouts;
    }
}

