/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.impl;

import com.flipkart.phantom.task.impl.TaskHandler;
import com.flipkart.phantom.task.impl.TaskHandlerExecutorRepository;
import com.flipkart.phantom.task.impl.TaskRequestWrapper;
import com.flipkart.phantom.task.impl.TaskResult;
import com.flipkart.phantom.task.spi.TaskContext;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskContextImpl
implements TaskContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskContextImpl.class);
    private static final String GET_CONFIG_COMMAND = "getConfig";
    private String hostName;
    private ObjectMapper objectMapper = new ObjectMapper();
    private TaskHandlerExecutorRepository executorRepository;

    @Override
    public String getConfig(String group, String key, int count) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("group", group);
        params.put("key", key);
        params.put("count", Integer.toString(count));
        TaskResult result = this.executeCommand(GET_CONFIG_COMMAND, null, params);
        if (result == null) {
            return "";
        }
        return new String((byte[])result.getData());
    }

    @Override
    public TaskResult executeCommand(String commandName, byte[] data, Map<String, String> params) throws UnsupportedOperationException {
        TaskRequestWrapper taskRequestWrapper = new TaskRequestWrapper();
        taskRequestWrapper.setData(data);
        taskRequestWrapper.setParams(params);
        return this.executorRepository.executeCommand(commandName, taskRequestWrapper);
    }

    @Override
    public Future<TaskResult> executeAsyncCommand(String commandName, byte[] data, Map<String, String> params) throws UnsupportedOperationException {
        TaskRequestWrapper taskRequestWrapper = new TaskRequestWrapper();
        taskRequestWrapper.setData(data);
        taskRequestWrapper.setParams(params);
        return this.executorRepository.executeAsyncCommand(commandName, taskRequestWrapper);
    }

    @Override
    public void profileCommand(TaskHandler handler, String command, Long diff, String tags) {
        try {
            HashMap<String, String> tsdbDataParams = new HashMap<String, String>();
            tsdbDataParams.put("key", handler.getName() + "TaskHandler-" + command);
            tsdbDataParams.put("pool", "agent");
            tsdbDataParams.put("type", "measure");
            tsdbDataParams.put("ts", String.valueOf(System.currentTimeMillis() * 1000L));
            if (tags != null) {
                tsdbDataParams.put("tags", "host=" + this.hostName + " " + tags);
            } else {
                tsdbDataParams.put("tags", "host=" + this.hostName);
            }
            tsdbDataParams.put("value", String.valueOf(diff));
        }
        catch (Exception e) {
            LOGGER.error("Exception while profiling agent command", (Throwable)e);
        }
    }

    public TaskHandlerExecutorRepository getExecutorRepository() {
        return this.executorRepository;
    }

    public void setExecutorRepository(TaskHandlerExecutorRepository executorRepository) {
        this.executorRepository = executorRepository;
    }

    @Override
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

