/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.utils;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixEventType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestLogger.class);

    public static void log(HystrixCommand executor) {
        List events;
        if (executor == null) {
            return;
        }
        if (executor.isExecutionComplete() && ((events = executor.getExecutionEvents()).size() > 1 || !events.contains(HystrixEventType.SUCCESS))) {
            LOGGER.warn("Command=" + executor.getCommandKey().name() + " " + "Group=" + executor.getCommandGroup().name() + " " + "ThreadPoolKey=" + executor.getThreadPoolKey().name() + " " + (events.size() > 0 ? "Events=" + RequestLogger.eventsToString(events) + " " : "") + "TimeTaken=" + executor.getExecutionTimeInMilliseconds() + " " + "IsResponseFromFallback=" + executor.isResponseFromFallback());
        }
    }

    private static String eventsToString(List<HystrixEventType> events) {
        String joined = "";
        boolean first = true;
        for (HystrixEventType event : events) {
            if (first) {
                first = false;
            } else {
                joined = joined + ",";
            }
            joined = joined + event.name();
        }
        return joined;
    }
}

