/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.impl;

import com.flipkart.phantom.task.impl.HystrixTaskHandler;
import com.flipkart.phantom.task.impl.TaskHandler;
import com.flipkart.phantom.task.impl.TaskHandlerExecutor;
import com.flipkart.phantom.task.impl.TaskResult;
import com.flipkart.phantom.task.impl.registry.TaskHandlerRegistry;
import com.flipkart.phantom.task.spi.TaskContext;
import com.netflix.hystrix.HystrixCommandProperties;
import java.util.Map;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskHandlerExecutorRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskHandlerExecutorRepository.class);
    public static final String ONLY_ALPHANUMERIC_REGEX = "[^\\dA-Za-z_]";
    public static final String WHITESPACE_REGEX = "\\s+";
    private static final int DEFAULT_THREAD_POOL_SIZE = 10;
    private TaskHandlerRegistry taskHandlerRegistry;
    private TaskContext taskContext;

    public TaskHandlerExecutor get(String commandName, String threadPoolName) {
        TaskHandler taskHandler;
        String refinedCommandName = commandName.replaceAll(ONLY_ALPHANUMERIC_REGEX, "").replaceAll(WHITESPACE_REGEX, "");
        String refinedThreadPoolName = threadPoolName.replaceAll(ONLY_ALPHANUMERIC_REGEX, "").replaceAll(WHITESPACE_REGEX, "");
        if (!commandName.equals(refinedCommandName)) {
            LOGGER.debug("Command names are not allowed to have Special characters/ whitespaces. Replacing: " + commandName + " with " + refinedCommandName);
        }
        if (!threadPoolName.equals(refinedThreadPoolName)) {
            LOGGER.debug("Thread pool names are not allowed to have Special characters/ whitespaces. Replacing: " + threadPoolName + " with " + refinedThreadPoolName);
        }
        if (threadPoolName == null || threadPoolName == "") {
            threadPoolName = commandName;
            LOGGER.debug("null/empty threadPoolName passed. defaulting to commandName: " + commandName);
        }
        if ((taskHandler = this.taskHandlerRegistry.getTaskHandlerByCommand(commandName)) != null) {
            if (!taskHandler.isActive()) {
                LOGGER.error("TaskHandler: " + taskHandler.getName() + " is not yet active. Command: " + commandName + " will not be processed");
                return null;
            }
            if (taskHandler instanceof HystrixTaskHandler) {
                HystrixTaskHandler hystrixTaskHandler = (HystrixTaskHandler)taskHandler;
                LOGGER.debug("Isolation strategy: " + hystrixTaskHandler.getIsolationStrategy() + " for " + hystrixTaskHandler);
                if (hystrixTaskHandler.getIsolationStrategy() == HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE) {
                    return new TaskHandlerExecutor(taskHandler, this.getTaskContext(), refinedCommandName);
                }
                if (this.taskHandlerRegistry.getPoolSize(threadPoolName) == null) {
                    LOGGER.debug("Did not find a predefined pool size for " + threadPoolName + ". Falling back to default value of " + 10);
                    return new TaskHandlerExecutor(taskHandler, this.getTaskContext(), refinedCommandName, hystrixTaskHandler.getExecutorTimeout(commandName), refinedThreadPoolName, 10);
                }
                return new TaskHandlerExecutor(taskHandler, this.getTaskContext(), refinedCommandName, hystrixTaskHandler.getExecutorTimeout(commandName), refinedThreadPoolName, this.taskHandlerRegistry.getPoolSize(threadPoolName));
            }
            return new TaskHandlerExecutor(taskHandler, this.getTaskContext(), refinedCommandName, 10000, refinedThreadPoolName, 10);
        }
        LOGGER.error("No TaskHandler found for command: '" + commandName + "'. Disconnecting");
        throw new UnsupportedOperationException("Invoked unsupported command : " + commandName);
    }

    public TaskHandlerExecutor get(String commandName) {
        return this.get(commandName, commandName);
    }

    public Future<TaskResult> executeAsyncCommand(String commandName, String threadPoolName, byte[] data, Map<String, String> params) throws UnsupportedOperationException {
        TaskHandlerExecutor command = this.get(commandName, threadPoolName);
        if (command == null) {
            throw new UnsupportedOperationException("Invoked unsupported command : " + commandName);
        }
        command.setData(data);
        command.setParams(params);
        return command.queue();
    }

    public TaskResult executeCommand(String commandName, String threadPoolName, byte[] data, Map<String, String> params) throws UnsupportedOperationException {
        TaskHandlerExecutor command = this.get(commandName, threadPoolName);
        if (command == null) {
            throw new UnsupportedOperationException("Invoked unsupported command : " + commandName);
        }
        command.setData(data);
        command.setParams(params);
        return (TaskResult)command.execute();
    }

    public TaskResult executeCommand(String commandName, byte[] data, Map<String, String> params) throws UnsupportedOperationException {
        return this.executeCommand(commandName, commandName, data, params);
    }

    public Future<TaskResult> executeAsyncCommand(String commandName, byte[] data, Map<String, String> params) throws UnsupportedOperationException {
        return this.executeAsyncCommand(commandName, commandName, data, params);
    }

    public TaskHandlerRegistry getTaskHandlerRegistry() {
        return this.taskHandlerRegistry;
    }

    public void setTaskHandlerRegistry(TaskHandlerRegistry taskHandlerRegistry) {
        this.taskHandlerRegistry = taskHandlerRegistry;
    }

    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    public void setTaskContext(TaskContext taskContext) {
        this.taskContext = taskContext;
    }
}

