/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.thrift.impl;

import com.flipkart.phantom.task.spi.AbstractHandler;
import com.flipkart.phantom.task.spi.TaskContext;
import com.flipkart.phantom.thrift.impl.ProxyServiceClient;
import com.flipkart.phantom.thrift.impl.proxy.SocketObjectFactory;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.thrift.ProcessFunction;
import org.apache.thrift.TBase;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public abstract class ThriftProxy
extends AbstractHandler
implements InitializingBean {
    private static final Map<Integer, String> THRIFT_ERRORS = new HashMap<Integer, String>();
    private static final String DEFAULT_SERVICE_INTERFACE_NAME = "Iface";
    private static final String DEFAULT_PROCESSOR_CLASS_NAME = "Processor";
    private static final String DEFAULT_RESULT_CLASS_NAME = "_result";
    private static final Logger LOGGER;
    private TProtocolFactory protocolFactory = new TBinaryProtocol.Factory();
    private String thriftServer;
    private int thriftPort;
    private int thriftTimeoutMillis = -1;
    private String thriftServiceClass;
    protected Map<String, ProcessFunction> processMap = new HashMap<String, ProcessFunction>();
    private int poolSize = 10;
    private long maxWait = 100L;
    private int maxIdle = this.poolSize;
    private int minIdle = this.poolSize / 2;
    private long timeBetweenEvictionRunsMillis = 20000L;
    private GenericObjectPool<Socket> socketPool;

    static {
        THRIFT_ERRORS.put(0, "Unknown exception");
        THRIFT_ERRORS.put(1, "Transport not open");
        THRIFT_ERRORS.put(2, "Transport already open");
        THRIFT_ERRORS.put(3, "Thrift timed out");
        THRIFT_ERRORS.put(4, "Reached end of file");
        LOGGER = LoggerFactory.getLogger(ThriftProxy.class);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.thriftServer, (String)"The 'thriftServer' may not be null");
        Assert.notNull((Object)this.thriftServiceClass, (String)"The 'thriftServiceClass' may not be null");
    }

    public void init(TaskContext context) throws Exception {
        if (this.thriftServiceClass == null) {
            throw new AssertionError((Object)"The 'thriftServiceClass' may not be null");
        }
        if (this.processMap == null || this.processMap.isEmpty()) {
            throw new AssertionError((Object)"ProcessFunctions not populated. Maybe The 'thriftServiceClass' is not a valid class?");
        }
        if (this.thriftTimeoutMillis == -1) {
            throw new Exception("'thriftTimeoutMillis' must be set to a non-negative value!");
        }
        this.socketPool = new GenericObjectPool((PoolableObjectFactory)new SocketObjectFactory(this), this.poolSize, 2, this.maxWait, this.maxIdle, this.minIdle, false, false, this.timeBetweenEvictionRunsMillis, 3, 1800000L, true);
    }

    public TTransport doRequest(TTransport clientTransport) {
        try (TSocket serviceSocket = null;){
            try {
                TProtocol clientProtocol = this.protocolFactory.getProtocol(clientTransport);
                TMessage message = clientProtocol.readMessageBegin();
                ProcessFunction invokedProcessFunction = this.getProcessMap().get(message.name);
                if (invokedProcessFunction == null) {
                    throw new RuntimeException("Unable to find a matching ProcessFunction for invoked method : " + message.name);
                }
                TBase args = invokedProcessFunction.getEmptyArgsInstance();
                args.read(clientProtocol);
                clientProtocol.readMessageEnd();
                TBase result = (TBase)Class.forName(String.valueOf(this.getThriftServiceClass()) + "$" + message.name + DEFAULT_RESULT_CLASS_NAME).newInstance();
                serviceSocket = new TSocket(this.getThriftServer(), this.getThriftPort(), this.getThriftTimeoutMillis());
                TBinaryProtocol serviceProtocol = new TBinaryProtocol((TTransport)serviceSocket);
                serviceSocket.open();
                ProxyServiceClient proxyClient = new ProxyServiceClient(clientProtocol, (TProtocol)serviceProtocol, (TProtocol)serviceProtocol);
                proxyClient.sendBase(message.name, args, message.seqid);
                proxyClient.receiveBase(result, message.name);
                LOGGER.debug("Processed message : " + this.getThriftServiceClass() + "." + message.name);
            }
            catch (Exception e) {
                if (e.getClass().isAssignableFrom(TTransportException.class)) {
                    throw new RuntimeException("Thrift transport exception executing the proxy service call : " + THRIFT_ERRORS.get(((TTransportException)e).getType()), e);
                }
                throw new RuntimeException("Exception executing the proxy service call : " + e.getMessage(), e);
            }
        }
        return clientTransport;
    }

    public TSocket getPooledSocket() {
        try {
            return new TSocket((Socket)this.socketPool.borrowObject());
        }
        catch (Exception e) {
            LOGGER.error("Error while borrowing TSocket : " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("Error while borrowing TSocket : " + e.getMessage(), e);
        }
    }

    public void returnPooledSocket(TSocket socket, boolean isConnectionValid) {
        try {
            if (isConnectionValid) {
                this.socketPool.returnObject((Object)socket.getSocket());
            } else {
                this.socketPool.invalidateObject((Object)socket.getSocket());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while returning TSocket : " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("Error while borrowing TSocket : " + e.getMessage(), e);
        }
    }

    public String getName() {
        return this.thriftServiceClass;
    }

    public String getType() {
        return "ThriftProxy";
    }

    public String getHost() {
        return this.thriftServer;
    }

    public int getPort() {
        return this.thriftPort;
    }

    public void shutdown(TaskContext context) throws Exception {
        super.deactivate();
    }

    public String getThriftServer() {
        return this.thriftServer;
    }

    public void setThriftServer(String thriftServer) {
        this.thriftServer = thriftServer;
    }

    public int getThriftPort() {
        return this.thriftPort;
    }

    public void setThriftPort(int thriftPort) {
        this.thriftPort = thriftPort;
    }

    public int getThriftTimeoutMillis() {
        return this.thriftTimeoutMillis;
    }

    public void setThriftTimeoutMillis(int thriftTimeoutMillis) {
        this.thriftTimeoutMillis = thriftTimeoutMillis;
    }

    public void setThriftServiceClass(String thriftServiceClass) {
        this.thriftServiceClass = thriftServiceClass;
        String serviceInterfaceClass = String.valueOf(this.thriftServiceClass) + "$" + DEFAULT_SERVICE_INTERFACE_NAME;
        try {
            Method[] methods;
            Class<?> serviceClass = Class.forName(serviceInterfaceClass);
            Method[] methodArray = methods = serviceClass.getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                String processFunctionClass = String.valueOf(this.thriftServiceClass) + "$" + DEFAULT_PROCESSOR_CLASS_NAME + "$" + method.getName();
                this.processMap.put(method.getName(), (ProcessFunction)Class.forName(processFunctionClass).newInstance());
                ++n2;
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to inspect specified Thrift service class. Error is : " + e.getMessage(), (Throwable)e);
            this.processMap.clear();
        }
    }

    public String getThriftServiceClass() {
        return this.thriftServiceClass;
    }

    public Map<String, ProcessFunction> getProcessMap() {
        return this.processMap;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }
}

