/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.thrift.impl;

import com.flipkart.phantom.event.ServiceProxyEvent;
import com.flipkart.phantom.task.spi.Executor;
import com.flipkart.phantom.task.spi.RequestWrapper;
import com.flipkart.phantom.task.spi.TaskContext;
import com.flipkart.phantom.thrift.impl.HystrixThriftProxy;
import com.flipkart.phantom.thrift.impl.ThriftProxy;
import com.flipkart.phantom.thrift.impl.ThriftRequestWrapper;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import org.apache.thrift.transport.TTransport;

public class ThriftProxyExecutor
extends HystrixCommand<TTransport>
implements Executor<TTransport> {
    public static final String DEFAULT_HYSTRIX_GROUP = "defaultThriftGroup";
    public static final String DEFAULT_HYSTRIX_THREAD_POOL = "defaultThriftThreadPool";
    public static final int DEFAULT_HYSTRIX_THREAD_POOL_SIZE = 20;
    protected ThriftProxy thriftProxy;
    protected TaskContext taskContext;
    protected TTransport clientTransport;
    protected ServiceProxyEvent.Builder eventBuilder;
    private static final String THRIFT_HANDLER = "THRIFT_HANDLER";

    protected ThriftProxyExecutor(HystrixThriftProxy hystrixThriftProxy, TaskContext taskContext, String commandName, RequestWrapper requestWrapper) {
        super(ThriftProxyExecutor.constructHystrixSetter(hystrixThriftProxy, commandName));
        this.thriftProxy = hystrixThriftProxy;
        this.taskContext = taskContext;
        ThriftRequestWrapper thriftRequestWrapper = (ThriftRequestWrapper)requestWrapper;
        this.clientTransport = thriftRequestWrapper.getClientSocket();
        this.eventBuilder = new ServiceProxyEvent.Builder(commandName, THRIFT_HANDLER);
    }

    protected TTransport run() {
        this.eventBuilder.withRequestExecutionStartTime(System.currentTimeMillis());
        return this.thriftProxy.doRequest(this.clientTransport);
    }

    protected TTransport getFallback() {
        if (this.thriftProxy instanceof HystrixThriftProxy) {
            HystrixThriftProxy hystrixThriftProxy = (HystrixThriftProxy)this.thriftProxy;
            hystrixThriftProxy.fallbackThriftRequest(this.clientTransport, this.taskContext);
            return this.clientTransport;
        }
        return null;
    }

    private static HystrixCommand.Setter constructHystrixSetter(HystrixThriftProxy hystrixThriftProxy, String commandName) {
        HystrixCommand.Setter setter = null;
        setter = hystrixThriftProxy.getGroupName() != null || !hystrixThriftProxy.getGroupName().equals("") ? HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)hystrixThriftProxy.getGroupName())) : HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)hystrixThriftProxy.getName()));
        setter = setter.andCommandKey(HystrixCommandKey.Factory.asKey((String)commandName));
        setter = hystrixThriftProxy.getThreadPoolName() != null || !hystrixThriftProxy.getThreadPoolName().equals("") ? setter.andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)hystrixThriftProxy.getThreadPoolName())) : setter.andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)DEFAULT_HYSTRIX_THREAD_POOL));
        Integer threadPoolSize = hystrixThriftProxy.getProxyThreadPoolSize() == null ? 20 : hystrixThriftProxy.getProxyThreadPoolSize();
        setter = setter.andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter().withCoreSize(threadPoolSize.intValue()));
        setter = setter.andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationThreadTimeoutInMilliseconds(hystrixThriftProxy.getExecutorTimeout(commandName)));
        if (hystrixThriftProxy.getHystrixProperties() != null) {
            setter = setter.andCommandPropertiesDefaults(hystrixThriftProxy.getHystrixProperties());
        }
        return setter;
    }

    public TTransport getClientTransport() {
        return this.clientTransport;
    }

    public void setClientTransport(TTransport clientTransport) {
        this.clientTransport = clientTransport;
    }

    public ServiceProxyEvent.Builder getEventBuilder() {
        return this.eventBuilder;
    }
}

