/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.thrift.impl;

import com.flipkart.phantom.task.spi.Executor;
import com.flipkart.phantom.task.spi.RequestWrapper;
import com.flipkart.phantom.task.spi.TaskContext;
import com.flipkart.phantom.thrift.impl.HystrixThriftProxy;
import com.flipkart.phantom.thrift.impl.ProxyServiceClient;
import com.flipkart.phantom.thrift.impl.ThriftProxy;
import com.flipkart.phantom.thrift.impl.ThriftRequestWrapper;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.ProcessFunction;
import org.apache.thrift.TBase;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftProxyExecutor
extends HystrixCommand<TTransport>
implements Executor {
    private static final Map<Integer, String> THRIFT_ERRORS = new HashMap<Integer, String>();
    private static final Logger LOGGER;
    public static final String DEFAULT_HYSTRIX_GROUP = "defaultThriftGroup";
    public static final String DEFAULT_HYSTRIX_THREAD_POOL = "defaultThriftThreadPool";
    public static final int DEFAULT_HYSTRIX_THREAD_POOL_SIZE = 20;
    private static final String DEFAULT_RESULT_CLASS_NAME = "_result";
    protected ThriftProxy thriftProxy;
    protected TaskContext taskContext;
    protected TTransport clientTransport;
    private TProtocolFactory protocolFactory = new TBinaryProtocol.Factory();

    protected ThriftProxyExecutor(HystrixThriftProxy hystrixThriftProxy, TaskContext taskContext, String commandName, RequestWrapper requestWrapper) {
        super(ThriftProxyExecutor.constructHystrixSetter(hystrixThriftProxy, commandName));
        this.thriftProxy = hystrixThriftProxy;
        this.taskContext = taskContext;
        ThriftRequestWrapper thriftRequestWrapper = (ThriftRequestWrapper)requestWrapper;
        this.clientTransport = thriftRequestWrapper.getClientSocket();
    }

    protected TTransport run() {
        TSocket serviceSocket = null;
        try {
            TProtocol clientProtocol = this.protocolFactory.getProtocol(this.clientTransport);
            TMessage message = clientProtocol.readMessageBegin();
            ProcessFunction invokedProcessFunction = this.thriftProxy.getProcessMap().get(message.name);
            if (invokedProcessFunction == null) {
                throw new RuntimeException("Unable to find a matching ProcessFunction for invoked method : " + message.name);
            }
            TBase args = invokedProcessFunction.getEmptyArgsInstance();
            args.read(clientProtocol);
            clientProtocol.readMessageEnd();
            TBase result = (TBase)Class.forName(this.thriftProxy.getThriftServiceClass() + "$" + message.name + DEFAULT_RESULT_CLASS_NAME).newInstance();
            serviceSocket = new TSocket(this.thriftProxy.getThriftServer(), this.thriftProxy.getThriftPort(), this.thriftProxy.getThriftTimeoutMillis());
            TBinaryProtocol serviceProtocol = new TBinaryProtocol((TTransport)serviceSocket);
            serviceSocket.open();
            ProxyServiceClient proxyClient = new ProxyServiceClient(clientProtocol, (TProtocol)serviceProtocol, (TProtocol)serviceProtocol);
            proxyClient.sendBase(message.name, args, message.seqid);
            proxyClient.receiveBase(result, message.name);
            LOGGER.debug("Processed message : " + this.thriftProxy.getThriftServiceClass() + "." + message.name);
        }
        catch (Exception e) {
            if (e.getClass().isAssignableFrom(TTransportException.class)) {
                throw new RuntimeException("Thrift transport exception executing the proxy service call : " + THRIFT_ERRORS.get(((TTransportException)e).getType()), e);
            }
            throw new RuntimeException("Exception executing the proxy service call : " + e.getMessage(), e);
        }
        finally {
            if (serviceSocket != null) {
                serviceSocket.close();
            }
        }
        return this.clientTransport;
    }

    protected TTransport getFallback() {
        if (this.thriftProxy instanceof HystrixThriftProxy) {
            HystrixThriftProxy hystrixThriftProxy = (HystrixThriftProxy)this.thriftProxy;
            hystrixThriftProxy.fallbackThriftRequest(this.clientTransport, this.taskContext);
            return this.clientTransport;
        }
        return null;
    }

    private static HystrixCommand.Setter constructHystrixSetter(HystrixThriftProxy hystrixThriftProxy, String commandName) {
        HystrixCommand.Setter setter = null;
        setter = hystrixThriftProxy.getGroupName() != null || !hystrixThriftProxy.getGroupName().equals("") ? HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)hystrixThriftProxy.getGroupName())) : HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)hystrixThriftProxy.getName()));
        setter = setter.andCommandKey(HystrixCommandKey.Factory.asKey((String)commandName));
        setter = hystrixThriftProxy.getThreadPoolName() != null || !hystrixThriftProxy.getThreadPoolName().equals("") ? setter.andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)hystrixThriftProxy.getThreadPoolName())) : setter.andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)DEFAULT_HYSTRIX_THREAD_POOL));
        Integer threadPoolSize = hystrixThriftProxy.getProxyThreadPoolSize() == null ? 20 : hystrixThriftProxy.getProxyThreadPoolSize();
        setter = setter.andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter().withCoreSize(threadPoolSize.intValue()));
        setter = setter.andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationThreadTimeoutInMilliseconds(hystrixThriftProxy.getExecutorTimeout(commandName)));
        if (hystrixThriftProxy.getHystrixProperties() != null) {
            setter = setter.andCommandPropertiesDefaults(hystrixThriftProxy.getHystrixProperties());
        }
        return setter;
    }

    public TTransport getClientTransport() {
        return this.clientTransport;
    }

    public void setClientTransport(TTransport clientTransport) {
        this.clientTransport = clientTransport;
    }

    public ThriftProxy getThriftProxy() {
        return this.thriftProxy;
    }

    static {
        THRIFT_ERRORS.put(0, "Unknown exception");
        THRIFT_ERRORS.put(1, "Transport not open");
        THRIFT_ERRORS.put(2, "Transport already open");
        THRIFT_ERRORS.put(3, "Thrift timed out");
        THRIFT_ERRORS.put(4, "Reached end of file");
        LOGGER = LoggerFactory.getLogger(ThriftProxyExecutor.class);
    }
}

