/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.http.impl.registry;

import com.flipkart.phantom.http.impl.HttpProxy;
import com.flipkart.phantom.task.spi.AbstractHandler;
import com.flipkart.phantom.task.spi.TaskContext;
import com.flipkart.phantom.task.spi.registry.AbstractHandlerRegistry;
import com.flipkart.phantom.task.spi.registry.HandlerConfigInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.trpr.platform.core.PlatformException;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class HttpProxyRegistry
extends AbstractHandlerRegistry {
    private static Logger LOGGER = LogFactory.getLogger(HttpProxyRegistry.class);
    private Map<String, HttpProxy> proxies = new HashMap<String, HttpProxy>();

    public AbstractHandlerRegistry.InitedHandlerInfo[] init(List<HandlerConfigInfo> handlerConfigInfoList, TaskContext taskContext) throws Exception {
        LinkedList<AbstractHandlerRegistry.InitedHandlerInfo> initedHanlderInfos = new LinkedList<AbstractHandlerRegistry.InitedHandlerInfo>();
        for (HandlerConfigInfo handlerConfigInfo : handlerConfigInfoList) {
            String[] proxyBeanIds;
            for (String proxyBeanId : proxyBeanIds = handlerConfigInfo.getProxyHandlerContext().getBeanNamesForType(HttpProxy.class)) {
                HttpProxy proxy = (HttpProxy)((Object)handlerConfigInfo.getProxyHandlerContext().getBean(proxyBeanId));
                try {
                    LOGGER.info("Initializing HttpProxy: " + proxy.getName());
                    proxy.init(taskContext);
                    proxy.activate();
                    initedHanlderInfos.add(new AbstractHandlerRegistry.InitedHandlerInfo((AbstractHandler)proxy, handlerConfigInfo));
                }
                catch (Exception e) {
                    LOGGER.error("Error initializing HttpProxy {}. Error is: " + e.getMessage(), (Object)proxy.getName(), (Object)e);
                    throw new PlatformException("Error initializing HttpProxy: " + proxy.getName(), (Throwable)e);
                }
                this.proxies.put(proxy.getName(), proxy);
            }
        }
        return initedHanlderInfos.toArray(new AbstractHandlerRegistry.InitedHandlerInfo[0]);
    }

    public void reinitHandler(String name, TaskContext taskContext) throws Exception {
        HttpProxy proxy = this.proxies.get(name);
        if (proxy != null) {
            try {
                proxy.deactivate();
                proxy.shutdown(taskContext);
                proxy.init(taskContext);
                proxy.activate();
            }
            catch (Exception e) {
                LOGGER.error("Error initializing HttpProxy {}. Error is: " + e.getMessage(), (Object)name, (Object)e);
                throw new PlatformException("Error reinitialising HttpProxy: " + name, (Throwable)e);
            }
        }
    }

    public void shutdown(TaskContext taskContext) throws Exception {
        for (String name : this.proxies.keySet()) {
            try {
                LOGGER.info("Shutting down HttpProxy: " + name);
                this.proxies.get(name).shutdown(taskContext);
                this.proxies.get(name).deactivate();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to shutdown HttpProxy: " + name, (Throwable)e);
            }
        }
    }

    public List<AbstractHandler> getHandlers() {
        return new ArrayList<AbstractHandler>(this.proxies.values());
    }

    public AbstractHandler getHandler(String name) {
        return this.proxies.get(name);
    }

    public void unregisterTaskHandler(AbstractHandler taskHandler) {
        this.proxies.remove(taskHandler.getName());
    }
}

