/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.jetty.filter;

import com.flipkart.phantom.task.impl.collector.EventDispatchingSpanCollector;
import com.flipkart.phantom.task.spi.tracing.TraceData;
import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.BraveHttpHeaders;
import com.github.kristofa.brave.EndPointSubmitter;
import com.github.kristofa.brave.FixedSampleRateTraceFilter;
import com.github.kristofa.brave.ServerTracer;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.TraceFilter;
import java.io.IOException;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class ServletTraceFilter
implements Filter,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletTraceFilter.class);
    private static final TraceFilter NO_TRACING = new FixedSampleRateTraceFilter(-1);
    private TraceFilter traceFilter = NO_TRACING;
    private EventDispatchingSpanCollector eventDispatchingSpanCollector;
    private ServerTracer serverTracer;
    private EndPointSubmitter endPointSubmitter;
    private String appContextPath;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.eventDispatchingSpanCollector, (String)"The 'eventDispatchingSpanCollector' may not be null");
        this.serverTracer = Brave.getServerTracer((SpanCollector)this.eventDispatchingSpanCollector, Arrays.asList(this.traceFilter));
        this.endPointSubmitter = Brave.getEndPointSubmitter();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this.serverTracer.clearCurrentSpan();
        if (request instanceof HttpServletRequest) {
            this.submitEndpoint((HttpServletRequest)request);
            TraceData traceData = this.getTraceDataFromHeaders(request);
            if (Boolean.FALSE.equals(traceData.shouldBeTraced())) {
                this.serverTracer.setStateNoTracing();
                LOGGER.debug("Not tracing request");
            } else {
                String spanName = this.getSpanName(traceData, (HttpServletRequest)request);
                if (traceData.getTraceId() != null && traceData.getSpanId() != null) {
                    LOGGER.debug("Received span information as part of request");
                    this.serverTracer.setStateCurrentTrace(traceData.getTraceId().longValue(), traceData.getSpanId().longValue(), traceData.getParentSpanId(), spanName);
                } else {
                    LOGGER.debug("Received no span state");
                    this.serverTracer.setStateUnknown(spanName);
                }
            }
        }
        this.serverTracer.setServerReceived();
        try {
            filterChain.doFilter(request, response);
        }
        finally {
            this.serverTracer.setServerSend();
        }
    }

    private void submitEndpoint(HttpServletRequest request) {
        if (!this.endPointSubmitter.endPointSubmitted()) {
            String contextPath = this.getAppContextPath() != null ? this.getAppContextPath() : request.getContextPath();
            String localAddr = request.getLocalAddr();
            int localPort = request.getLocalPort();
            this.endPointSubmitter.submit(localAddr, localPort, contextPath);
            LOGGER.debug("Setting endpoint: addr: {}, port: {}, contextpath: " + contextPath, (Object)localAddr, (Object)localPort);
        }
    }

    private String getSpanName(TraceData traceData, HttpServletRequest request) {
        if (traceData.getSpanName() == null || traceData.getSpanName().isEmpty()) {
            return request.getRequestURI();
        }
        return traceData.getSpanName();
    }

    private TraceData getTraceDataFromHeaders(ServletRequest request) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        TraceData traceData = new TraceData();
        traceData.setTraceId(this.longOrNull(httpRequest.getHeader(BraveHttpHeaders.TraceId.getName())));
        traceData.setSpanId(this.longOrNull(httpRequest.getHeader(BraveHttpHeaders.SpanId.getName())));
        traceData.setParentSpanId(this.longOrNull(httpRequest.getHeader(BraveHttpHeaders.ParentSpanId.getName())));
        traceData.setShouldBeSampled(this.nullOrBoolean(httpRequest.getHeader(BraveHttpHeaders.Sampled.getName())));
        traceData.setSpanName(httpRequest.getHeader(BraveHttpHeaders.SpanName.getName()));
        return traceData;
    }

    private Boolean nullOrBoolean(String value) {
        return value == null ? null : Boolean.valueOf(value);
    }

    private Long longOrNull(String value) {
        if (value == null) {
            return null;
        }
        return this.convertToLong(value);
    }

    private long convertToLong(String id) {
        if (id.length() == 0 || id.length() > 16) {
            throw new NumberFormatException(id + " should be a <=16 character lower-hex string with no prefix");
        }
        long result = 0L;
        for (char c : id.toCharArray()) {
            result <<= 4;
            if (c >= '0' && c <= '9') {
                result |= (long)(c - 48);
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                result |= (long)(c - 97 + 10);
                continue;
            }
            throw new NumberFormatException("character " + c + " not lower hex in " + id);
        }
        return result;
    }

    public void setTraceFilter(TraceFilter traceFilter) {
        this.traceFilter = traceFilter;
    }

    public void setEventDispatchingSpanCollector(EventDispatchingSpanCollector eventDispatchingSpanCollector) {
        this.eventDispatchingSpanCollector = eventDispatchingSpanCollector;
    }

    public String getAppContextPath() {
        return this.appContextPath;
    }

    public void setAppContextPath(String appContextPath) {
        this.appContextPath = appContextPath;
    }
}

