/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.server.netty.handler.command;

import com.flipkart.phantom.event.ServiceProxyEvent;
import com.flipkart.phantom.event.ServiceProxyEventProducer;
import com.flipkart.phantom.runtime.impl.server.netty.handler.command.CommandInterpreter;
import com.flipkart.phantom.task.impl.TaskHandlerExecutor;
import com.flipkart.phantom.task.impl.TaskHandlerExecutorRepository;
import com.flipkart.phantom.task.impl.TaskRequestWrapper;
import com.flipkart.phantom.task.impl.TaskResult;
import com.flipkart.phantom.task.impl.collector.EventDispatchingSpanCollector;
import com.flipkart.phantom.task.impl.interceptor.ServerRequestInterceptor;
import com.flipkart.phantom.task.spi.Executor;
import com.flipkart.phantom.task.spi.RequestContext;
import com.flipkart.phantom.task.spi.RequestWrapper;
import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.FixedSampleRateTraceFilter;
import com.github.kristofa.brave.ServerSpan;
import com.github.kristofa.brave.ServerTracer;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.TraceFilter;
import com.google.common.base.Optional;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncCommandProcessingChannelHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncCommandProcessingChannelHandler.class);
    public static final String POOL_PARAM = "pool";
    private static final String ASYNC_COMMAND_HANDLER = "ASYNC_COMMAND_HANDLER";
    private static final String DEFAULT_SERVICE_NAME = "Async Command Proxy";
    private static final TraceFilter NO_TRACING = new FixedSampleRateTraceFilter(-1);
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = -1;
    private static String hostName = "localhost";
    private String serviceName = "Async Command Proxy";
    private int hostPort;
    private ChannelGroup defaultChannelGroup;
    private TaskHandlerExecutorRepository repository;
    private ServiceProxyEventProducer eventProducer;
    private TraceFilter traceFilter = NO_TRACING;
    private EventDispatchingSpanCollector eventDispatchingSpanCollector;

    public void channelBound(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
        super.channelBound(ctx, event);
        if (InetSocketAddress.class.isAssignableFrom(event.getValue().getClass())) {
            this.hostPort = ((InetSocketAddress)event.getValue()).getPort();
        }
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
        super.channelOpen(ctx, event);
        this.defaultChannelGroup.add((Object)event.getChannel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent event) throws Exception {
        long receiveTime = System.currentTimeMillis();
        if (MessageEvent.class.isAssignableFrom(event.getClass())) {
            CommandInterpreter commandInterpreter = new CommandInterpreter();
            CommandInterpreter.ProxyCommand readCommand = commandInterpreter.readCommand((MessageEvent)event);
            LOGGER.debug("Read Command : " + readCommand);
            String pool = readCommand.getCommandParams().get(POOL_PARAM);
            String commandName = readCommand.getCommand();
            String poolName = pool != null ? pool : commandName;
            TaskRequestWrapper taskRequestWrapper = new TaskRequestWrapper();
            taskRequestWrapper.setCommandName(commandName);
            taskRequestWrapper.setData(readCommand.getCommandData());
            taskRequestWrapper.setParams(readCommand.getCommandParams());
            taskRequestWrapper.setServiceName(Optional.of((Object)this.serviceName));
            ServerRequestInterceptor<TaskRequestWrapper, TaskResult> serverRequestInterceptor = this.initializeServerTracing(taskRequestWrapper);
            TaskHandlerExecutor executor = (TaskHandlerExecutor)this.repository.getExecutor(commandName, poolName, taskRequestWrapper);
            Optional transportError = Optional.absent();
            try {
                this.repository.executeAsyncCommand(commandName, poolName, taskRequestWrapper);
                LOGGER.debug("Successfully started execution for async command " + commandName);
            }
            catch (Exception e) {
                RuntimeException runtimeException = new RuntimeException("Error asynchronously executing the command : " + readCommand, e);
                transportError = Optional.of((Object)runtimeException);
                LOGGER.error("Error asynchronously executing the command", (Throwable)e);
            }
            finally {
                serverRequestInterceptor.process((Object)new TaskResult(true, "The command dispatched for async execution"), transportError);
                if (this.eventProducer != null) {
                    String requestID = readCommand.getCommandParams().get("requestID");
                    ServiceProxyEvent.Builder eventBuilder = executor == null ? new ServiceProxyEvent.Builder(readCommand.getCommand(), ASYNC_COMMAND_HANDLER).withEventSource(((Object)((Object)this)).getClass().getName()) : executor.getEventBuilder().withCommandData((Executor)executor).withEventSource(executor.getClass().getName());
                    eventBuilder.withRequestId(requestID).withRequestReceiveTime(receiveTime);
                    this.eventProducer.publishEvent(eventBuilder.build());
                } else {
                    LOGGER.debug("eventProducer not set, not publishing event");
                }
            }
        }
        super.handleUpstream(ctx, event);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) throws Exception {
        LOGGER.warn("Exception {} thrown on Channel {}. Disconnect initiated", (Object)event, (Object)event.getChannel());
        event.getChannel().close();
    }

    private ServerRequestInterceptor<TaskRequestWrapper, TaskResult> initializeServerTracing(TaskRequestWrapper executorRequest) {
        ServerRequestInterceptor serverRequestInterceptor = new ServerRequestInterceptor();
        List<TraceFilter> traceFilters = Arrays.asList(this.traceFilter);
        ServerTracer serverTracer = Brave.getServerTracer((SpanCollector)this.eventDispatchingSpanCollector, traceFilters);
        serverRequestInterceptor.setEndPointSubmitter(Brave.getEndPointSubmitter());
        serverRequestInterceptor.setServerTracer(serverTracer);
        serverRequestInterceptor.setServiceHost(hostName);
        serverRequestInterceptor.setServicePort(this.hostPort);
        serverRequestInterceptor.setServiceName(this.serviceName);
        serverRequestInterceptor.process((RequestWrapper)executorRequest);
        ServerSpan serverSpan = Brave.getServerSpanThreadBinder().getCurrentServerSpan();
        RequestContext serverRequestContext = new RequestContext();
        serverRequestContext.setCurrentServerSpan(serverSpan);
        executorRequest.setRequestContext(Optional.of((Object)serverRequestContext));
        return serverRequestInterceptor;
    }

    public ChannelGroup getDefaultChannelGroup() {
        return this.defaultChannelGroup;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setDefaultChannelGroup(ChannelGroup defaultChannelGroup) {
        this.defaultChannelGroup = defaultChannelGroup;
    }

    public TaskHandlerExecutorRepository getRepository() {
        return this.repository;
    }

    public void setRepository(TaskHandlerExecutorRepository repository) {
        this.repository = repository;
    }

    public void setEventProducer(ServiceProxyEventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }

    static {
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Unable to resolve local host name. Will use default host name : localhost");
        }
    }
}

