/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.spring;

import com.flipkart.phantom.runtime.impl.notifier.HystrixEventReceiver;
import com.flipkart.phantom.runtime.impl.server.AbstractNetworkServer;
import com.flipkart.phantom.runtime.impl.spring.admin.SPConfigServiceImpl;
import com.flipkart.phantom.runtime.spi.spring.admin.SPConfigService;
import com.flipkart.phantom.task.spi.AbstractHandler;
import com.flipkart.phantom.task.spi.TaskContext;
import com.flipkart.phantom.task.spi.registry.AbstractHandlerRegistry;
import com.flipkart.phantom.task.spi.registry.HandlerConfigInfo;
import com.netflix.hystrix.Hystrix;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifier;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.trpr.platform.core.PlatformException;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.event.PlatformEventProducer;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.model.event.PlatformEvent;
import org.trpr.platform.runtime.common.RuntimeVariables;
import org.trpr.platform.runtime.impl.bootstrapext.spring.ApplicationContextFactory;
import org.trpr.platform.runtime.impl.config.FileLocator;
import org.trpr.platform.runtime.spi.bootstrapext.BootstrapExtension;
import org.trpr.platform.runtime.spi.component.ComponentContainer;

public class ServiceProxyComponentContainer
implements ComponentContainer {
    private static final String DEFAULT_EVENT_PRODUCER = "platformEventProducer";
    private static final String FILE_PREFIX = "file:";
    private static final String CONFIG_SERVICE_BEAN = "configService";
    private static final String TASK_CONTEXT_BEAN = "taskContext";
    private static final Logger LOGGER = LogFactory.getLogger(ServiceProxyComponentContainer.class);
    private static AbstractApplicationContext commonProxyHandlerBeansContext;
    private List<HandlerConfigInfo> handlerConfigInfoList = new LinkedList<HandlerConfigInfo>();
    private BootstrapExtension[] loadedBootstrapExtensions;
    private ClassLoader tccl;
    private List<AbstractHandlerRegistry> registries = new ArrayList<AbstractHandlerRegistry>();
    private SPConfigService configService;
    private TaskContext taskContext;

    public static AbstractApplicationContext getCommonProxyHandlerBeansContext() {
        return commonProxyHandlerBeansContext;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void setLoadedBootstrapExtensions(BootstrapExtension ... bootstrapExtensions) {
        this.loadedBootstrapExtensions = bootstrapExtensions;
    }

    public void init() throws PlatformException {
        HandlerConfigInfo proxyListenerBeanFiles;
        HandlerConfigInfo handlerConfigInfo;
        File[] proxyHandlerBeansFiles;
        if (HystrixPlugins.getInstance().getEventNotifier() == null) {
            HystrixPlugins.getInstance().registerEventNotifier((HystrixEventNotifier)new HystrixEventReceiver());
        }
        this.tccl = Thread.currentThread().getContextClassLoader();
        ApplicationContextFactory defaultCtxFactory = null;
        BootstrapExtension[] bootstrapExtensionArray = this.loadedBootstrapExtensions;
        int n = this.loadedBootstrapExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            BootstrapExtension be = bootstrapExtensionArray[n2];
            if (ApplicationContextFactory.class.isAssignableFrom(be.getClass())) {
                defaultCtxFactory = (ApplicationContextFactory)be;
                break;
            }
            ++n2;
        }
        commonProxyHandlerBeansContext = new ClassPathXmlApplicationContext(new String[]{"packaged/common-proxy-config.xml"}, (ApplicationContext)defaultCtxFactory.getCommonBeansContext());
        this.handlerConfigInfoList.add(new HandlerConfigInfo(new File("packaged/common-proxy-config.xml"), null, commonProxyHandlerBeansContext));
        this.configService = (SPConfigServiceImpl)commonProxyHandlerBeansContext.getBean(CONFIG_SERVICE_BEAN);
        ((SPConfigServiceImpl)this.configService).setComponentContainer(this);
        if (RuntimeVariables.getRuntimeNature().equalsIgnoreCase("SERVER")) {
            commonProxyHandlerBeansContext = new ClassPathXmlApplicationContext(new String[]{"packaged/common-proxy-server-nature-config.xml"}, (ApplicationContext)ServiceProxyComponentContainer.getCommonProxyHandlerBeansContext());
            this.handlerConfigInfoList.add(new HandlerConfigInfo(new File("packaged/common-proxy-server-nature-config.xml"), null, ServiceProxyComponentContainer.getCommonProxyHandlerBeansContext()));
        }
        File[] fileArray = proxyHandlerBeansFiles = FileLocator.findFiles((String)"spring-proxy-handler-config.xml");
        int n3 = proxyHandlerBeansFiles.length;
        n = 0;
        while (n < n3) {
            File proxyHandlerBeansFile = fileArray[n];
            handlerConfigInfo = new HandlerConfigInfo(proxyHandlerBeansFile);
            this.loadProxyHandlerContext(handlerConfigInfo);
            LOGGER.info("Loaded: " + proxyHandlerBeansFile);
            ++n;
        }
        handlerConfigInfo = proxyListenerBeanFiles = FileLocator.findFiles((String)"spring-proxy-listener-config.xml");
        int n4 = ((File[])handlerConfigInfo).length;
        n3 = 0;
        while (n3 < n4) {
            HandlerConfigInfo proxyListenerBeanFile = handlerConfigInfo[n3];
            FileSystemXmlApplicationContext listenerContext = new FileSystemXmlApplicationContext(new String[]{FILE_PREFIX + proxyListenerBeanFile.getAbsolutePath()}, (ApplicationContext)ServiceProxyComponentContainer.getCommonProxyHandlerBeansContext());
            this.handlerConfigInfoList.add(new HandlerConfigInfo((File)proxyListenerBeanFile, null, (AbstractApplicationContext)listenerContext));
            LOGGER.info("Loaded: " + proxyListenerBeanFile);
            ++n3;
        }
        for (HandlerConfigInfo handlerConfigInfo2 : this.handlerConfigInfoList) {
            String[] networkServerBeans;
            String[] registryBeans;
            String[] stringArray = registryBeans = handlerConfigInfo2.getProxyHandlerContext().getBeanNamesForType(AbstractHandlerRegistry.class);
            int n5 = registryBeans.length;
            int listenerContext = 0;
            while (listenerContext < n5) {
                String registryBean = stringArray[listenerContext];
                AbstractHandlerRegistry registry = (AbstractHandlerRegistry)handlerConfigInfo2.getProxyHandlerContext().getBean(registryBean);
                LOGGER.info("Found handler registry: " + registry.getClass().getName());
                try {
                    this.taskContext = (TaskContext)ServiceProxyComponentContainer.getCommonProxyHandlerBeansContext().getBean(TASK_CONTEXT_BEAN);
                    AbstractHandlerRegistry.InitedHandlerInfo[] initedHandlerInfos = registry.init(this.handlerConfigInfoList, this.taskContext);
                    LOGGER.info("Initialized handler registry: " + registry.getClass().getName());
                    AbstractHandlerRegistry.InitedHandlerInfo[] initedHandlerInfoArray = initedHandlerInfos;
                    int n6 = initedHandlerInfos.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        AbstractHandlerRegistry.InitedHandlerInfo initedHandlerInfo = initedHandlerInfoArray[n7];
                        this.configService.addHandlerConfigPath(initedHandlerInfo.getHandlerConfigInfo().getXmlConfigFile(), initedHandlerInfo.getInitedHandler());
                        ++n7;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error initializing registry: " + registry.getClass().getName());
                    throw new PlatformException("Error initializing registry: " + registry.getClass().getName(), (Throwable)e);
                }
                this.configService.addHandlerRegistry(registry);
                this.registries.add(registry);
                ++listenerContext;
            }
            String[] stringArray2 = networkServerBeans = handlerConfigInfo2.getProxyHandlerContext().getBeanNamesForType(AbstractNetworkServer.class);
            int n8 = networkServerBeans.length;
            n5 = 0;
            while (n5 < n8) {
                String networkServerBean = stringArray2[n5];
                AbstractNetworkServer networkServer = (AbstractNetworkServer)handlerConfigInfo2.getProxyHandlerContext().getBean(networkServerBean);
                try {
                    networkServer.init();
                }
                catch (Exception e) {
                    LOGGER.error("Error initializeing network server: " + networkServer.getServerType() + ": " + networkServer.getServerEndpoint());
                    throw new PlatformException("Error initializeing network server: " + networkServer.getServerType() + ": " + networkServer.getServerEndpoint(), (Throwable)e);
                }
                this.configService.addDeployedNetworkServer(networkServer);
                ++n5;
            }
        }
    }

    public void destroy() throws PlatformException {
        Hystrix.reset();
        for (AbstractHandlerRegistry registry : this.registries) {
            try {
                registry.shutdown(this.taskContext);
            }
            catch (Exception e) {
                LOGGER.warn("Error shutting down registry: " + registry.getClass().getName());
            }
        }
        for (HandlerConfigInfo handlerConfigInfo : this.handlerConfigInfoList) {
            handlerConfigInfo.getProxyHandlerContext().close();
        }
        this.handlerConfigInfoList = null;
    }

    public void publishEvent(PlatformEvent event) {
        PlatformEventProducer publisher = (PlatformEventProducer)commonProxyHandlerBeansContext.getBean(DEFAULT_EVENT_PRODUCER);
        publisher.publishEvent(event);
    }

    public void publishBootstrapEvent(PlatformEvent bootstrapEvent) {
        this.publishEvent(bootstrapEvent);
    }

    public void reloadHandler(AbstractHandler handler, Resource resource) {
        AbstractHandlerRegistry registry = this.getRegistry(handler.getName());
        registry.unregisterTaskHandler(handler);
        LOGGER.debug("Unregistered TaskHandler: " + handler.getName());
        this.loadComponent(resource);
        for (HandlerConfigInfo handlerConfigInfo : this.handlerConfigInfoList) {
            if (!handlerConfigInfo.getXmlConfigFile().getAbsolutePath().equalsIgnoreCase(((FileSystemResource)resource).getFile().getAbsolutePath())) continue;
            LinkedList<HandlerConfigInfo> reloadHandlerConfigInfoList = new LinkedList<HandlerConfigInfo>();
            reloadHandlerConfigInfoList.add(handlerConfigInfo);
            try {
                registry.init(reloadHandlerConfigInfoList, this.taskContext);
            }
            catch (Exception e) {
                LOGGER.error("Error updating registry : " + registry.getClass().getName() + " for handler : " + handler.getName(), (Throwable)e);
                throw new PlatformException("Error updating registry : " + registry.getClass().getName() + " for handler : " + handler.getName(), (Throwable)e);
            }
            return;
        }
    }

    public void loadComponent(Resource resource) {
        if (!FileSystemResource.class.isAssignableFrom(resource.getClass()) || !resource.getFilename().equalsIgnoreCase("spring-proxy-handler-config.xml")) {
            throw new UnsupportedOperationException("Proxy handers can be loaded only from files by name : spring-proxy-handler-config.xml. Specified resource is : " + resource.toString());
        }
        this.loadProxyHandlerContext(new HandlerConfigInfo(((FileSystemResource)resource).getFile()));
    }

    public AbstractHandlerRegistry getRegistry(String handlerName) {
        for (AbstractHandlerRegistry registry : this.registries) {
            if (registry.getHandler(handlerName) == null) continue;
            return registry;
        }
        throw new UnsupportedOperationException("No known regsitries exist for AbstractHandler by name : " + handlerName);
    }

    private void loadProxyHandlerContext(HandlerConfigInfo handlerConfigInfo) {
        for (HandlerConfigInfo loadedHandlerConfigInfo : this.handlerConfigInfoList) {
            if (!loadedHandlerConfigInfo.equals((Object)handlerConfigInfo)) continue;
            handlerConfigInfo = loadedHandlerConfigInfo;
            break;
        }
        if (handlerConfigInfo.getProxyHandlerContext() != null) {
            handlerConfigInfo.getProxyHandlerContext().close();
            this.handlerConfigInfoList.remove(handlerConfigInfo);
        }
        ClassLoader proxyHandlerCL = this.tccl;
        File customLibPath = new File(handlerConfigInfo.getXmlConfigFile().getParentFile(), "lib");
        if (customLibPath.exists() && customLibPath.isDirectory()) {
            try {
                File[] libFiles = customLibPath.listFiles();
                URL[] libURLs = new URL[libFiles.length];
                int i = 0;
                while (i < libFiles.length) {
                    libURLs[i] = new URL(FILE_PREFIX + libFiles[i].getAbsolutePath());
                    ++i;
                }
                proxyHandlerCL = new URLClassLoader(libURLs, this.tccl);
            }
            catch (MalformedURLException e) {
                throw new PlatformException((Throwable)e);
            }
        }
        handlerConfigInfo.loadProxyHandlerContext(proxyHandlerCL, ServiceProxyComponentContainer.getCommonProxyHandlerBeansContext());
        this.handlerConfigInfoList.add(handlerConfigInfo);
    }
}

