/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.server.netty.handler.command;

import com.flipkart.phantom.runtime.impl.server.netty.handler.command.CommandInterpreter;
import com.flipkart.phantom.task.impl.TaskHandlerExecutor;
import com.flipkart.phantom.task.impl.TaskHandlerExecutorRepository;
import com.flipkart.phantom.task.impl.TaskResult;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandProcessingChannelHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandProcessingChannelHandler.class);
    public static final String POOL_PARAM = "pool";
    private ChannelGroup defaultChannelGroup;
    private TaskHandlerExecutorRepository repository;

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
        super.channelOpen(ctx, event);
        this.defaultChannelGroup.add((Object)event.getChannel());
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent event) throws Exception {
        if (MessageEvent.class.isAssignableFrom(event.getClass())) {
            CommandInterpreter commandInterpreter = new CommandInterpreter();
            CommandInterpreter.ProxyCommand readCommand = commandInterpreter.readCommand((MessageEvent)event);
            LOGGER.debug("Read Command : " + readCommand);
            String pool = readCommand.getCommandParams().get(POOL_PARAM);
            TaskHandlerExecutor executor = pool != null ? this.repository.get(readCommand.getCommand(), pool) : this.repository.get(readCommand.getCommand(), readCommand.getCommand());
            executor.setParams(readCommand.getCommandParams());
            executor.setData(readCommand.getCommandData());
            try {
                TaskResult result = null;
                if (executor.getCallInvocationType() == 0) {
                    result = (TaskResult)executor.execute();
                } else {
                    executor.queue();
                    result = new TaskResult(true, "The command dispatched for async execution");
                }
                LOGGER.debug("The output is: " + result);
                commandInterpreter.writeCommandExecutionResponse(ctx, event, result);
            }
            catch (Exception e) {
                LOGGER.error("Error in executing command/fallBack : " + readCommand, (Throwable)e);
                throw new RuntimeException("Error in executing command : " + readCommand, e);
            }
        }
        super.handleUpstream(ctx, event);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) throws Exception {
        LOGGER.warn("Exception {} thrown on Channel {}. Disconnect initiated", (Object)event, (Object)event.getChannel());
        event.getChannel().close();
    }

    public ChannelGroup getDefaultChannelGroup() {
        return this.defaultChannelGroup;
    }

    public void setDefaultChannelGroup(ChannelGroup defaultChannelGroup) {
        this.defaultChannelGroup = defaultChannelGroup;
    }

    public TaskHandlerExecutorRepository getRepository() {
        return this.repository;
    }

    public void setRepository(TaskHandlerExecutorRepository repository) {
        this.repository = repository;
    }
}

