/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.server.netty.handler.command;

import com.flipkart.phantom.runtime.impl.server.netty.handler.command.CommandInterpreter;
import com.flipkart.phantom.task.impl.TaskHandlerExecutorRepository;
import java.util.Map;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncCommandProcessingChannelHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncCommandProcessingChannelHandler.class);
    public static final String POOL_PARAM = "pool";
    private ChannelGroup defaultChannelGroup;
    private TaskHandlerExecutorRepository repository;

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
        super.channelOpen(ctx, event);
        this.defaultChannelGroup.add((Object)event.getChannel());
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent event) throws Exception {
        if (MessageEvent.class.isAssignableFrom(event.getClass())) {
            CommandInterpreter commandInterpreter = new CommandInterpreter();
            CommandInterpreter.ProxyCommand readCommand = commandInterpreter.readCommand((MessageEvent)event);
            LOGGER.debug("Read Command : " + readCommand);
            String pool = readCommand.getCommandParams().get(POOL_PARAM);
            String commandName = readCommand.getCommand();
            String poolName = pool != null ? pool : commandName;
            Map<String, String> params = readCommand.getCommandParams();
            byte[] data = readCommand.getCommandData();
            try {
                this.repository.executeAsyncCommand(commandName, poolName, data, params);
                LOGGER.debug("Successfully started execution for async command " + commandName);
            }
            catch (Exception e) {
                LOGGER.error("Error asynchronously executing the command", (Throwable)e);
            }
        }
        super.handleUpstream(ctx, event);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) throws Exception {
        LOGGER.warn("Exception {} thrown on Channel {}. Disconnect initiated", (Object)event, (Object)event.getChannel());
        event.getChannel().close();
    }

    public ChannelGroup getDefaultChannelGroup() {
        return this.defaultChannelGroup;
    }

    public void setDefaultChannelGroup(ChannelGroup defaultChannelGroup) {
        this.defaultChannelGroup = defaultChannelGroup;
    }

    public TaskHandlerExecutorRepository getRepository() {
        return this.repository;
    }

    public void setRepository(TaskHandlerExecutorRepository repository) {
        this.repository = repository;
    }
}

