/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.server.oio;

import com.flipkart.phantom.event.ServiceProxyEvent;
import com.flipkart.phantom.event.ServiceProxyEventProducer;
import com.flipkart.phantom.runtime.impl.server.AbstractNetworkServer;
import com.flipkart.phantom.runtime.impl.server.concurrent.NamedThreadFactory;
import com.flipkart.phantom.runtime.impl.server.netty.handler.command.CommandInterpreter;
import com.flipkart.phantom.runtime.spi.server.NetworkServer;
import com.flipkart.phantom.task.impl.TaskHandler;
import com.flipkart.phantom.task.impl.TaskHandlerExecutor;
import com.flipkart.phantom.task.impl.TaskRequestWrapper;
import com.flipkart.phantom.task.impl.TaskResult;
import com.flipkart.phantom.task.impl.collector.EventDispatchingSpanCollector;
import com.flipkart.phantom.task.impl.interceptor.ServerRequestInterceptor;
import com.flipkart.phantom.task.spi.Executor;
import com.flipkart.phantom.task.spi.RequestContext;
import com.flipkart.phantom.task.spi.RequestWrapper;
import com.flipkart.phantom.task.spi.repository.ExecutorRepository;
import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.FixedSampleRateTraceFilter;
import com.github.kristofa.brave.ServerSpan;
import com.github.kristofa.brave.ServerTracer;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.TraceFilter;
import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.trpr.platform.runtime.impl.config.FileLocator;

public class UDSOIOServer
extends AbstractNetworkServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(UDSOIOServer.class);
    private static final int INVALID_POOL_SIZE = -1;
    private static final String DEFAULT_SERVICE_NAME = "UDS OIO Server";
    private static final String COMMAND_HANDLER = "COMMAND_HANDLER";
    private static final TraceFilter NO_TRACING = new FixedSampleRateTraceFilter(-1);
    private int DEFAULT_CLIENT_TIMEOUT_MILLIS = 300;
    private static final String DEFAULT_JUNIX_NATIVE_DIRECTORY = "uds-lib";
    private static final String JUNIX_LIB_SYSTEM_PROPERTY = "org.newsclub.net.unix.library.path";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = -1;
    private static String hostName = "localhost";
    private String serviceName = "UDS OIO Server";
    private int hostPort;
    private int workerPoolSize = -1;
    private int executorQueueSize = Runtime.getRuntime().availableProcessors() * 12;
    private int clientSocketTimeoutMillis = this.DEFAULT_CLIENT_TIMEOUT_MILLIS;
    private ExecutorService workerExecutors;
    private String junixNativeLibDirectoryName = "uds-lib";
    private String socketName;
    private String socketDir;
    private File socketFile;
    public AFUNIXServerSocket socket;
    private ExecutorRepository<TaskRequestWrapper, TaskResult, TaskHandler> repository;
    private ServiceProxyEventProducer eventProducer;
    private TraceFilter traceFilter = NO_TRACING;
    private EventDispatchingSpanCollector eventDispatchingSpanCollector;

    static {
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Unable to resolve local host name. Will use default host name : localhost");
        }
    }

    public NetworkServer.TransmissionProtocol getTransmissionProtocol() {
        return NetworkServer.TRANSMISSION_PROTOCOL.UDS;
    }

    public void afterPropertiesSet() throws Exception {
        File[] junixDirectories = FileLocator.findDirectories((String)this.junixNativeLibDirectoryName, null);
        if (junixDirectories == null || junixDirectories.length == 0) {
            throw new RuntimeException("Did not find junixDirectory: " + this.junixNativeLibDirectoryName);
        }
        LOGGER.info("Found junixDirectory: " + junixDirectories[0].getAbsolutePath());
        System.setProperty(JUNIX_LIB_SYSTEM_PROPERTY, junixDirectories[0].getAbsolutePath());
        Assert.notNull((Object)this.socketDir, (String)"socketDir is a required property for UDSNetworkServer");
        Assert.notNull((Object)this.socketName, (String)"socketName is a required property for UDSNetworkServer");
        Assert.notNull((Object)this.eventDispatchingSpanCollector, (String)"The 'eventDispatchingSpanCollector' may not be null");
        this.socketFile = new File(new File(this.socketDir), this.socketName);
        LOGGER.info("Socket file: " + this.socketFile.getAbsolutePath());
        try {
            this.socketAddress = new AFUNIXSocketAddress(this.socketFile);
            this.socket = AFUNIXServerSocket.newInstance();
            this.socket.bind((SocketAddress)this.socketAddress);
            this.hostPort = this.socketAddress.getPort();
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating Socket Address. ", e);
        }
        if (this.getWorkerExecutors() == null) {
            if (this.getWorkerPoolSize() != -1) {
                this.setWorkerExecutors(new ThreadPoolExecutor(this.getWorkerPoolSize(), this.getWorkerPoolSize(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.getExecutorQueueSize()), (ThreadFactory)new NamedThreadFactory("UDSOIOServer-Worker"), new ThreadPoolExecutor.CallerRunsPolicy()));
            } else {
                this.setWorkerExecutors(Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("UDSOIOServer-Worker")));
            }
        }
        super.afterPropertiesSet();
        LOGGER.info("UDS Server startup complete");
    }

    public String toString() {
        return "UDSOIONetworkServer [socketFile=" + this.socketFile.getAbsolutePath() + "] ";
    }

    protected void doStartServer() throws RuntimeException {
        new SocketListener();
    }

    protected void doStopServer() throws RuntimeException {
        try {
            this.socket.close();
            this.workerExecutors.shutdown();
        }
        catch (IOException e) {
            throw new RuntimeException("Error shutting down UDS server : " + this.toString(), e);
        }
    }

    public String getServerType() {
        return DEFAULT_SERVICE_NAME;
    }

    public String getServerEndpoint() {
        return this.socketFile.toString();
    }

    private ServerRequestInterceptor<TaskRequestWrapper, TaskResult> initializeServerTracing(TaskRequestWrapper executorRequest) {
        ServerSpan serverSpan = Brave.getServerSpanThreadBinder().getCurrentServerSpan();
        RequestContext serverRequestContext = new RequestContext();
        serverRequestContext.setCurrentServerSpan(serverSpan);
        executorRequest.setRequestContext(Optional.of((Object)serverRequestContext));
        ServerRequestInterceptor serverRequestInterceptor = new ServerRequestInterceptor();
        List<TraceFilter> traceFilters = Arrays.asList(this.traceFilter);
        ServerTracer serverTracer = Brave.getServerTracer((SpanCollector)this.eventDispatchingSpanCollector, traceFilters);
        serverRequestInterceptor.setEndPointSubmitter(Brave.getEndPointSubmitter());
        serverRequestInterceptor.setServerTracer(serverTracer);
        serverRequestInterceptor.setServiceHost(hostName);
        serverRequestInterceptor.setServicePort(this.hostPort);
        serverRequestInterceptor.setServiceName(this.serviceName);
        serverRequestInterceptor.process((RequestWrapper)executorRequest);
        return serverRequestInterceptor;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public int getWorkerPoolSize() {
        return this.workerPoolSize;
    }

    public void setWorkerPoolSize(int workerPoolSize) {
        this.workerPoolSize = workerPoolSize;
    }

    public int getClientSocketTimeoutMillis() {
        return this.clientSocketTimeoutMillis;
    }

    public void setClientSocketTimeoutMillis(int clientSocketTimeoutMillis) {
        this.clientSocketTimeoutMillis = clientSocketTimeoutMillis;
    }

    public ExecutorService getWorkerExecutors() {
        return this.workerExecutors;
    }

    public void setWorkerExecutors(ExecutorService workerExecutors) {
        this.workerExecutors = workerExecutors;
    }

    public String getSocketDir() {
        return this.socketDir;
    }

    public void setSocketDir(String socketDir) {
        this.socketDir = socketDir;
    }

    public String getSocketName() {
        return this.socketName;
    }

    public void setSocketName(String socketName) {
        this.socketName = socketName;
    }

    public String getJunixNativeLibDirectoryName() {
        return this.junixNativeLibDirectoryName;
    }

    public void setJunixNativeLibDirectoryName(String junixNativeLibDirectoryName) {
        this.junixNativeLibDirectoryName = junixNativeLibDirectoryName;
    }

    public ExecutorRepository getRepository() {
        return this.repository;
    }

    public void setRepository(ExecutorRepository<TaskRequestWrapper, TaskResult, TaskHandler> repository) {
        this.repository = repository;
    }

    public void setEventProducer(ServiceProxyEventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }

    public int getExecutorQueueSize() {
        return this.executorQueueSize;
    }

    public void setExecutorQueueSize(int executorQueueSize) {
        this.executorQueueSize = executorQueueSize;
    }

    public void setTraceFilter(TraceFilter traceFilter) {
        this.traceFilter = traceFilter;
    }

    public void setEventDispatchingSpanCollector(EventDispatchingSpanCollector eventDispatchingSpanCollector) {
        this.eventDispatchingSpanCollector = eventDispatchingSpanCollector;
    }

    class CommandProcessor
    implements Runnable {
        Socket client;

        CommandProcessor(Socket client) {
            this.client = client;
        }

        @Override
        public void run() {
            long receiveTime = System.currentTimeMillis();
            Object executor = null;
            CommandInterpreter.ProxyCommand readCommand = null;
            Optional transportError = Optional.absent();
            TaskResult result = null;
            ServerRequestInterceptor serverRequestInterceptor = null;
            try {
                try {
                    CommandInterpreter commandInterpreter = new CommandInterpreter();
                    readCommand = commandInterpreter.readCommand(this.client.getInputStream());
                    LOGGER.debug("Read Command : " + readCommand);
                    String pool = (String)readCommand.getCommandParams().get("pool");
                    TaskRequestWrapper taskRequestWrapper = new TaskRequestWrapper();
                    taskRequestWrapper.setCommandName(readCommand.getCommand());
                    taskRequestWrapper.setData(readCommand.getCommandData());
                    taskRequestWrapper.setParams(readCommand.getCommandParams());
                    taskRequestWrapper.setServiceName(Optional.of((Object)UDSOIOServer.this.serviceName));
                    serverRequestInterceptor = UDSOIOServer.this.initializeServerTracing(taskRequestWrapper);
                    executor = pool != null ? (TaskHandlerExecutor)UDSOIOServer.this.repository.getExecutor(readCommand.getCommand(), pool, (RequestWrapper)taskRequestWrapper) : (TaskHandlerExecutor)UDSOIOServer.this.repository.getExecutor(readCommand.getCommand(), readCommand.getCommand(), (RequestWrapper)taskRequestWrapper);
                    if (executor.getCallInvocationType() == 0) {
                        result = (TaskResult)executor.execute();
                    } else {
                        executor.queue();
                        result = new TaskResult(true, "The command dispatched for async execution");
                    }
                    LOGGER.debug("The output is: " + result);
                    commandInterpreter.writeCommandExecutionResponse(this.client.getOutputStream(), result);
                }
                catch (Exception e) {
                    RuntimeException runtimeException = new RuntimeException("Error in executing command : " + readCommand, e);
                    transportError = Optional.of((Object)runtimeException);
                    throw runtimeException;
                }
            }
            catch (Throwable throwable) {
                if (serverRequestInterceptor != null) {
                    serverRequestInterceptor.process(result, transportError);
                }
                if (UDSOIOServer.this.eventProducer != null) {
                    Map params = readCommand.getCommandParams();
                    ServiceProxyEvent.Builder eventBuilder = executor == null ? new ServiceProxyEvent.Builder(readCommand.getCommand(), UDSOIOServer.COMMAND_HANDLER).withEventSource(this.getClass().getName()) : executor.getEventBuilder().withCommandData(executor).withEventSource(executor.getClass().getName());
                    eventBuilder.withRequestId((String)params.get("requestID")).withRequestReceiveTime(receiveTime);
                    if (params.containsKey("requestSentTime")) {
                        eventBuilder.withRequestSentTime(Long.valueOf((String)params.get("requestSentTime")).longValue());
                    }
                    UDSOIOServer.this.eventProducer.publishEvent(eventBuilder.build());
                } else {
                    LOGGER.debug("eventProducer not set, not publishing event");
                }
                if (this.client != null) {
                    try {
                        this.client.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("Error closing client socket : " + e.getMessage(), (Throwable)e);
                    }
                }
                throw throwable;
            }
            if (serverRequestInterceptor != null) {
                serverRequestInterceptor.process((Object)result, transportError);
            }
            if (UDSOIOServer.this.eventProducer != null) {
                Map params = readCommand.getCommandParams();
                ServiceProxyEvent.Builder eventBuilder = executor == null ? new ServiceProxyEvent.Builder(readCommand.getCommand(), UDSOIOServer.COMMAND_HANDLER).withEventSource(this.getClass().getName()) : executor.getEventBuilder().withCommandData((Executor)executor).withEventSource(executor.getClass().getName());
                eventBuilder.withRequestId((String)params.get("requestID")).withRequestReceiveTime(receiveTime);
                if (params.containsKey("requestSentTime")) {
                    eventBuilder.withRequestSentTime(Long.valueOf((String)params.get("requestSentTime")).longValue());
                }
                UDSOIOServer.this.eventProducer.publishEvent(eventBuilder.build());
            } else {
                LOGGER.debug("eventProducer not set, not publishing event");
            }
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (IOException e) {
                    LOGGER.error("Error closing client socket : " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    class SocketListener
    extends Thread {
        SocketListener() {
            this.setName("UDSOIO_Listener");
            this.start();
        }

        @Override
        public void run() {
            while (true) {
                Socket client = null;
                try {
                    client = UDSOIOServer.this.socket.accept();
                    client.setSoTimeout(UDSOIOServer.this.getClientSocketTimeoutMillis());
                    UDSOIOServer.this.workerExecutors.submit(new CommandProcessor(client));
                }
                catch (IOException e) {
                    throw new RuntimeException("Error accepting client socket connections : " + e.getMessage(), e);
                }
            }
        }
    }
}

