/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.server.oio;

import com.flipkart.phantom.event.ServiceProxyEventProducer;
import com.flipkart.phantom.runtime.impl.server.AbstractNetworkServer;
import com.flipkart.phantom.runtime.impl.server.concurrent.NamedThreadFactory;
import com.flipkart.phantom.runtime.impl.server.netty.handler.command.CommandInterpreter;
import com.flipkart.phantom.runtime.spi.server.NetworkServer;
import com.flipkart.phantom.task.impl.TaskHandlerExecutor;
import com.flipkart.phantom.task.impl.TaskRequestWrapper;
import com.flipkart.phantom.task.impl.TaskResult;
import com.flipkart.phantom.task.spi.Executor;
import com.flipkart.phantom.task.spi.RequestWrapper;
import com.flipkart.phantom.task.spi.repository.ExecutorRepository;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.trpr.platform.runtime.impl.config.FileLocator;

public class UDSOIOServer
extends AbstractNetworkServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(UDSOIOServer.class);
    private static final int INVALID_POOL_SIZE = -1;
    private int DEFAULT_CLIENT_TIMEOUT_MILLIS = 300;
    private static final String DEFAULT_JUNIX_NATIVE_DIRECTORY = "uds-lib";
    private static final String JUNIX_LIB_SYSTEM_PROPERTY = "org.newsclub.net.unix.library.path";
    private int workerPoolSize = -1;
    private int clientSocketTimeoutMillis = this.DEFAULT_CLIENT_TIMEOUT_MILLIS;
    private ExecutorService workerExecutors;
    private String junixNativeLibDirectoryName = "uds-lib";
    private String socketName;
    private String socketDir;
    private File socketFile;
    public AFUNIXServerSocket socket;
    private ExecutorRepository repository;
    private ServiceProxyEventProducer eventProducer;
    private static final String COMMAND_HANDLER = "COMMAND_HANDLER";

    public NetworkServer.TransmissionProtocol getTransmissionProtocol() {
        return NetworkServer.TRANSMISSION_PROTOCOL.UDS;
    }

    public void afterPropertiesSet() throws Exception {
        File[] junixDirectories = FileLocator.findDirectories((String)this.junixNativeLibDirectoryName, null);
        if (junixDirectories == null || junixDirectories.length == 0) {
            throw new RuntimeException("Did not find junixDirectory: " + this.junixNativeLibDirectoryName);
        }
        LOGGER.info("Found junixDirectory: " + junixDirectories[0].getAbsolutePath());
        System.setProperty(JUNIX_LIB_SYSTEM_PROPERTY, junixDirectories[0].getAbsolutePath());
        Assert.notNull((Object)this.socketDir, (String)"socketDir is a required property for UDSNetworkServer");
        Assert.notNull((Object)this.socketName, (String)"socketName is a required property for UDSNetworkServer");
        this.socketFile = new File(new File(this.socketDir), this.socketName);
        LOGGER.info("Socket file: " + this.socketFile.getAbsolutePath());
        try {
            this.socketAddress = new AFUNIXSocketAddress(this.socketFile);
            this.socket = AFUNIXServerSocket.newInstance();
            this.socket.bind((SocketAddress)this.socketAddress);
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating Socket Address. ", e);
        }
        if (this.getWorkerExecutors() == null) {
            if (this.getWorkerPoolSize() != -1) {
                this.setWorkerExecutors(Executors.newFixedThreadPool(this.getWorkerPoolSize(), (ThreadFactory)new NamedThreadFactory("UDSOIOServer-Worker")));
            } else {
                this.setWorkerExecutors(Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("UDSOIOServer-Worker")));
            }
        }
        super.afterPropertiesSet();
        LOGGER.info("UDS Server startup complete");
    }

    public String toString() {
        return "UDSOIONetworkServer [socketFile=" + this.socketFile.getAbsolutePath() + "] ";
    }

    protected void doStartServer() throws RuntimeException {
        new SocketListener();
    }

    protected void doStopServer() throws RuntimeException {
        try {
            this.socket.close();
            this.workerExecutors.shutdown();
        }
        catch (IOException e) {
            throw new RuntimeException("Error shutting down UDS server : " + this.toString(), e);
        }
    }

    public String getServerType() {
        return "UDS OIO Server";
    }

    public String getServerEndpoint() {
        return this.socketFile.toString();
    }

    public int getWorkerPoolSize() {
        return this.workerPoolSize;
    }

    public void setWorkerPoolSize(int workerPoolSize) {
        this.workerPoolSize = workerPoolSize;
    }

    public int getClientSocketTimeoutMillis() {
        return this.clientSocketTimeoutMillis;
    }

    public void setClientSocketTimeoutMillis(int clientSocketTimeoutMillis) {
        this.clientSocketTimeoutMillis = clientSocketTimeoutMillis;
    }

    public ExecutorService getWorkerExecutors() {
        return this.workerExecutors;
    }

    public void setWorkerExecutors(ExecutorService workerExecutors) {
        this.workerExecutors = workerExecutors;
    }

    public String getSocketDir() {
        return this.socketDir;
    }

    public void setSocketDir(String socketDir) {
        this.socketDir = socketDir;
    }

    public String getSocketName() {
        return this.socketName;
    }

    public void setSocketName(String socketName) {
        this.socketName = socketName;
    }

    public String getJunixNativeLibDirectoryName() {
        return this.junixNativeLibDirectoryName;
    }

    public void setJunixNativeLibDirectoryName(String junixNativeLibDirectoryName) {
        this.junixNativeLibDirectoryName = junixNativeLibDirectoryName;
    }

    public ExecutorRepository getRepository() {
        return this.repository;
    }

    public void setRepository(ExecutorRepository repository) {
        this.repository = repository;
    }

    public void setEventProducer(ServiceProxyEventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }

    class CommandProcessor
    implements Runnable {
        Socket client;

        CommandProcessor(Socket client) {
            this.client = client;
        }

        @Override
        public void run() {
            String commandName;
            Class<?> eventSource;
            Object executor = null;
            CommandInterpreter.ProxyCommand readCommand = null;
            try {
                TaskResult result;
                CommandInterpreter commandInterpreter = new CommandInterpreter();
                readCommand = commandInterpreter.readCommand(this.client.getInputStream());
                LOGGER.debug("Read Command : " + readCommand);
                String pool = (String)readCommand.getCommandParams().get("pool");
                TaskRequestWrapper taskRequestWrapper = new TaskRequestWrapper();
                taskRequestWrapper.setData(readCommand.getCommandData());
                taskRequestWrapper.setParams(readCommand.getCommandParams());
                executor = pool != null ? (TaskHandlerExecutor)UDSOIOServer.this.repository.getExecutor(readCommand.getCommand(), pool, (RequestWrapper)taskRequestWrapper) : (TaskHandlerExecutor)UDSOIOServer.this.repository.getExecutor(readCommand.getCommand(), readCommand.getCommand(), (RequestWrapper)taskRequestWrapper);
                if (executor.getCallInvocationType() == 0) {
                    result = (TaskResult)executor.execute();
                } else {
                    executor.queue();
                    result = new TaskResult(true, "The command dispatched for async execution");
                }
                LOGGER.debug("The output is: " + result);
                commandInterpreter.writeCommandExecutionResponse(this.client.getOutputStream(), result);
                eventSource = executor == null ? this.getClass() : executor.getClass();
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException("Error in processing command : " + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    String commandName2;
                    Class<?> eventSource2 = executor == null ? this.getClass() : executor.getClass();
                    String string = commandName2 = readCommand == null ? null : readCommand.getCommand();
                    if (UDSOIOServer.this.eventProducer != null) {
                        UDSOIOServer.this.eventProducer.publishEvent((Executor)executor, commandName2, eventSource2, UDSOIOServer.COMMAND_HANDLER);
                    } else {
                        LOGGER.debug("eventProducer not set, not publishing event");
                    }
                    if (this.client != null) {
                        try {
                            this.client.close();
                        }
                        catch (IOException e2) {
                            LOGGER.error("Error closing client socket : " + e2.getMessage(), (Throwable)e2);
                        }
                    }
                    throw throwable;
                }
            }
            String string = commandName = readCommand == null ? null : readCommand.getCommand();
            if (UDSOIOServer.this.eventProducer != null) {
                UDSOIOServer.this.eventProducer.publishEvent((Executor)executor, commandName, eventSource, UDSOIOServer.COMMAND_HANDLER);
            } else {
                LOGGER.debug("eventProducer not set, not publishing event");
            }
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (IOException e) {
                    LOGGER.error("Error closing client socket : " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    class SocketListener
    extends Thread {
        SocketListener() {
            this.setName("UDSOIO_Listener");
            this.start();
        }

        @Override
        public void run() {
            while (true) {
                Socket client = null;
                try {
                    client = UDSOIOServer.this.socket.accept();
                    client.setSoTimeout(UDSOIOServer.this.getClientSocketTimeoutMillis());
                    UDSOIOServer.this.workerExecutors.execute(new CommandProcessor(client));
                }
                catch (IOException e) {
                    throw new RuntimeException("Error accepting client socket connections : " + e.getMessage(), e);
                }
            }
        }
    }
}

